/*
 * Decompiled with CFR 0.152.
 */
package com.ontey.updater;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ontey.Main;
import com.ontey.log.Log;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class Updater {
    private static final Source SOURCE = Source.HANGAR;
    private static final int SPIGOT_RESOURCE_ID = 128478;
    private static final String HANGAR_AUTHOR = "Ontey";
    private static final String HANGAR_PROJECT = "CustomCommand";

    public static void checkForUpdates() {
        CompletableFuture.runAsync(() -> {
            try {
                String latest = switch (SOURCE.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> Updater.fetchSpigot();
                    case 1 -> Updater.fetchHangar();
                };
                String current = Main.version;
                if (latest != null && !latest.equalsIgnoreCase(current)) {
                    Bukkit.getScheduler().runTask((Plugin)Main.instance, () -> Log.info("[Updater] New version available: " + latest + " (current: " + current + ")"));
                }
            }
            catch (Exception e) {
                Log.warning("[Updater] Could not check for updates: " + e.getMessage());
            }
        });
    }

    private static String fetchSpigot() throws Exception {
        String url = "https://api.spiget.org/v2/resources/128478/versions/latest";
        HttpURLConnection conn = (HttpURLConnection)URI.create(url).toURL().openConnection();
        conn.setRequestProperty("User-Agent", "Updater");
        try (InputStreamReader reader = new InputStreamReader(conn.getInputStream());){
            JsonObject obj = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            String string = obj.get("name").getAsString();
            return string;
        }
    }

    private static String fetchHangar() throws Exception {
        String url = "https://hangar.papermc.io/api/v1/projects/Ontey/CustomCommand/versions";
        HttpURLConnection conn = (HttpURLConnection)URI.create(url).toURL().openConnection();
        conn.setRequestProperty("User-Agent", "Updater");
        try (InputStreamReader reader = new InputStreamReader(conn.getInputStream());){
            JsonObject root = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            String string = root.getAsJsonArray("result").get(0).getAsJsonObject().get("name").getAsString();
            return string;
        }
    }

    private static enum Source {
        SPIGOT,
        HANGAR;

    }
}

