/*
 * Decompiled with CFR 0.152.
 */
package com.ontey.tab;

import com.ontey.files.Commands;
import com.ontey.holder.Paths;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class Tab {
    private final YamlConfiguration config;
    private final String command;
    private final String path;

    public Tab(YamlConfiguration config, String command) {
        this.config = config;
        this.command = command;
        this.path = Paths.tab(command);
    }

    public int length() {
        int i = 1;
        ConfigurationSection section = this.config.getConfigurationSection(this.path);
        if (section == null) {
            return 0;
        }
        while (section.isList(Tab.str(i)) || section.isString(Tab.str(i))) {
            ++i;
        }
        return i - 1;
    }

    private List<List<String>> rawTabCompleter() {
        ArrayList<List<String>> out = new ArrayList<List<String>>();
        ConfigurationSection section = this.config.getConfigurationSection(this.path);
        if (section == null) {
            return out;
        }
        int i = 1;
        while (section.isList(Tab.str(i)) || section.isString(Tab.str(i))) {
            List<String> options = Commands.getField(this.config, this.path + "." + Tab.str(i));
            out.add(options);
            ++i;
        }
        return out;
    }

    public List<String> getTabCompleter(String[] args) {
        if (args.length > this.length() || this.rawTabCompleter().get(args.length - 1).isEmpty()) {
            return Commands.getNoTab(this.config, this.command);
        }
        return this.rawTabCompleter().get(args.length - 1);
    }

    private static String str(Object obj) {
        return obj.toString();
    }

    public static List<String> onlinePlayers() {
        ArrayList<String> out = new ArrayList<String>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            out.add(player.getName());
        }
        return out;
    }
}

