/*
 * Decompiled with CFR 0.152.
 */
package com.ontey.files;

import com.ontey.CustomCommand;
import com.ontey.Main;
import com.ontey.files.Config;
import com.ontey.holder.Paths;
import com.ontey.log.Log;
import com.ontey.tab.Tab;
import com.ontey.types.AdvancedBroadcast;
import com.ontey.types.Args;
import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Commands {
    @NotNull
    public static final @NotNull List<@NotNull CustomCommand> registeredCommands = new ArrayList<CustomCommand>();

    private Commands() {
    }

    public static void load() {
        File dir = new File(Main.instance.getDataFolder(), "commands");
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                Log.info("Couldn't create the commands directory. Disabling plugin");
                Main.disablePlugin();
                return;
            }
            Commands.loadExamples();
        }
    }

    private static void loadExamples() {
        File examples = new File(Main.instance.getDataFolder(), "commands/examples.yml");
        if (examples.exists()) {
            return;
        }
        Main.instance.saveResource("examples.yml", false);
        File rootFile = new File(Main.instance.getDataFolder(), "examples.yml");
        if (rootFile.exists() && !rootFile.renameTo(examples)) {
            Log.info("Couldn't copy the examples file");
        }
    }

    @NotNull
    public static @NotNull List<@NotNull String> getList(@NotNull YamlConfiguration config, @NotNull String path) {
        List list;
        if (config == null) {
            Commands.$$$reportNull$$$0(0);
        }
        if (path == null) {
            Commands.$$$reportNull$$$0(1);
        }
        if ((list = config.getList(path)) == null || list.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> out = new ArrayList<String>();
        for (Object obj : list) {
            out.add(obj == null ? "" : obj.toString());
        }
        ArrayList<String> arrayList = out;
        if (arrayList == null) {
            Commands.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    public static @NotNull List<@NotNull String> getField(@NotNull YamlConfiguration config, @NotNull String path) {
        if (config == null) {
            Commands.$$$reportNull$$$0(3);
        }
        if (path == null) {
            Commands.$$$reportNull$$$0(4);
        }
        return config.isString(path) ? Collections.singletonList(config.getString(path, "")) : Commands.getList(config, path);
    }

    @NotNull
    public static @NotNull List<@NotNull String> getMessages(@NotNull YamlConfiguration config, @NotNull String command) {
        if (config == null) {
            Commands.$$$reportNull$$$0(5);
        }
        if (command == null) {
            Commands.$$$reportNull$$$0(6);
        }
        return Commands.getField(config, Paths.message(command));
    }

    @NotNull
    public static @NotNull List<@NotNull String> getBroadcasts(@NotNull YamlConfiguration config, @NotNull String command) {
        if (config == null) {
            Commands.$$$reportNull$$$0(7);
        }
        if (command == null) {
            Commands.$$$reportNull$$$0(8);
        }
        return Commands.getField(config, Paths.broadcast(command));
    }

    @NotNull
    public static @NotNull List<@NotNull String> getCommands(@NotNull YamlConfiguration config, @NotNull String command) {
        if (config == null) {
            Commands.$$$reportNull$$$0(9);
        }
        if (command == null) {
            Commands.$$$reportNull$$$0(10);
        }
        return Commands.getField(config, Paths.commands(command));
    }

    @NotNull
    public static @NotNull List<@NotNull String> getAliases(@NotNull YamlConfiguration config, @NotNull String command) {
        if (config == null) {
            Commands.$$$reportNull$$$0(11);
        }
        if (command == null) {
            Commands.$$$reportNull$$$0(12);
        }
        return Commands.getField(config, Paths.aliases(command));
    }

    @NotNull
    public static Args getArgs(@NotNull YamlConfiguration config, @NotNull String command) {
        if (config == null) {
            Commands.$$$reportNull$$$0(13);
        }
        if (command == null) {
            Commands.$$$reportNull$$$0(14);
        }
        return new Args(config, command);
    }

    @Nullable
    public static String getPermission(@NotNull YamlConfiguration config, @NotNull String command) {
        if (config == null) {
            Commands.$$$reportNull$$$0(15);
        }
        if (command == null) {
            Commands.$$$reportNull$$$0(16);
        }
        if (!Commands.requiresPermission(config, command)) {
            return null;
        }
        String value = config.getString(Paths.permission(command));
        return value != null ? value : Config.defaultPerm(command);
    }

    public static boolean requiresPermission(@NotNull YamlConfiguration config, @NotNull String command) {
        if (config == null) {
            Commands.$$$reportNull$$$0(17);
        }
        if (command == null) {
            Commands.$$$reportNull$$$0(18);
        }
        return config.getBoolean(Paths.permissionRequired(command), true);
    }

    @NotNull
    public static String getDescription(@NotNull YamlConfiguration config, @NotNull String command) {
        if (config == null) {
            Commands.$$$reportNull$$$0(19);
        }
        if (command == null) {
            Commands.$$$reportNull$$$0(20);
        }
        String string = String.join((CharSequence)"\n", Commands.getField(config, Paths.description(command)));
        if (string == null) {
            Commands.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public static String getUsage(@NotNull YamlConfiguration config, @NotNull String command) {
        if (config == null) {
            Commands.$$$reportNull$$$0(22);
        }
        if (command == null) {
            Commands.$$$reportNull$$$0(23);
        }
        String string = String.join((CharSequence)"\n", Commands.getField(config, Paths.usage(command)));
        if (string == null) {
            Commands.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public static AdvancedBroadcast getAdvancedBroadcast(@NotNull YamlConfiguration config, @NotNull String command) {
        if (config == null) {
            Commands.$$$reportNull$$$0(25);
        }
        if (command == null) {
            Commands.$$$reportNull$$$0(26);
        }
        String range = config.getString(Paths.AdvancedBroadcast.range(command), "-1");
        List<String> permission = Commands.getField(config, Paths.AdvancedBroadcast.permission(command));
        List<String> broadcast = Commands.getField(config, Paths.AdvancedBroadcast.broadcast(command));
        List<String> condition = Commands.getField(config, Paths.AdvancedBroadcast.condition(command));
        return new AdvancedBroadcast(range, permission, condition, broadcast);
    }

    @NotNull
    public static String getNamespace(@NotNull YamlConfiguration config, @NotNull String command) {
        if (config == null) {
            Commands.$$$reportNull$$$0(27);
        }
        if (command == null) {
            Commands.$$$reportNull$$$0(28);
        }
        String string = config.getString(Paths.namespace(command), Config.DEFAULT_NAMESPACE);
        if (string == null) {
            Commands.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public static @NotNull List<@NotNull String> getNoTab(@NotNull YamlConfiguration config, @NotNull String command) {
        Config.NoTab noTabMode;
        if (config == null) {
            Commands.$$$reportNull$$$0(30);
        }
        if (command == null) {
            Commands.$$$reportNull$$$0(31);
        }
        Config.NoTab noTab = noTabMode = Config.getNoTab(config.getString(Paths.noTab(command)));
        int n = 0;
        List<String> list = switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"NONE", "PLAYERS"}, (Config.NoTab)noTab, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> List.of();
            case 1 -> Tab.onlinePlayers();
            case -1 -> Config.noTab();
        };
        if (list == null) {
            Commands.$$$reportNull$$$0(32);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 21, 24, 29, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 21: 
            case 24: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/ontey/files/Commands";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 26: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/ontey/files/Commands";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getList";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsage";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getNoTab";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getList";
                break;
            }
            case 2: 
            case 21: 
            case 24: 
            case 29: 
            case 32: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getField";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMessages";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBroadcasts";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCommands";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAliases";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getArgs";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPermission";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "requiresPermission";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getUsage";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getAdvancedBroadcast";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getNamespace";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getNoTab";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 21, 24, 29, 32 -> new IllegalStateException(string);
        };
    }
}

