/*
 * Decompiled with CFR 0.152.
 */
package com.ontey.execution;

import com.ontey.execution.Evaluation;
import com.ontey.files.Config;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.command.CommandSender;

public class MacroStrings {
    public static String replaceMacroStrings(String str, CommandSender sender, String[] args) {
        Pattern pattern = Pattern.compile("(?<!\\\\)\\$\\((.*?)(?<!\\\\)\\)");
        Matcher matcher = pattern.matcher(str);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String rep = MacroStrings.evalMacroStrings(matcher.group(1), sender, args);
            rep = rep == null ? "" : rep;
            rep = rep.replace("\\)", ")");
            matcher.appendReplacement(sb, Matcher.quoteReplacement(rep));
        }
        matcher.appendTail(sb);
        return MacroStrings.removeEscapedMacroStrings(sb.toString());
    }

    private static String removeEscapedMacroStrings(String str) {
        return str.replaceAll("\\\\(\\$\\((.*?)\\))", "$1");
    }

    private static String evalMacroStrings(String str, CommandSender sender, String[] args) {
        if (str.replace(" ", "").matches("[+-]?\\d+(\\.\\d+)?[*/%+^-][+-]?\\d+(\\.\\d+)?")) {
            return MacroStrings.evalCalculation(str.replace(" ", ""));
        }
        if (str.matches("(.*?)\\?(.*?):(.*?)")) {
            return MacroStrings.evalTernary(str, sender, args);
        }
        return "$(" + str + ")";
    }

    private static String evalTernary(String str, CommandSender sender, String[] args) {
        int idx = str.indexOf(63);
        String condition = str.substring(0, idx);
        String _true = str.substring(idx + 1, str.indexOf(58, idx));
        String _false = str.substring(str.indexOf(58, idx));
        boolean result = Evaluation.evalCondition(condition, sender, args);
        return result ? MacroStrings.tnSpace(_true.trim()) : MacroStrings.tnSpace(_false.trim());
    }

    private static String evalCalculation(String str) {
        int idx = MacroStrings.index(str, "*/%+^-");
        if (idx == -1) {
            return str;
        }
        double left = Double.parseDouble(str.substring(0, idx));
        double right = Double.parseDouble(str.substring(idx + 1));
        char op = str.charAt(idx);
        return MacroStrings.trimDecimal(MacroStrings.calculate(left, right, op));
    }

    private static String tnSpace(String str) {
        return str.replace(Config.ph("tn.space"), " ");
    }

    private static double calculate(double left, double right, char op) {
        return switch (op) {
            case '+' -> left + right;
            case '*' -> left * right;
            case '-' -> left - right;
            case '/' -> left / right;
            case '%' -> left % right;
            case '^' -> Math.pow(left, right);
            default -> throw new IllegalStateException("A number might be too high: " + left + op + right);
        };
    }

    private static int index(String str, String chars) {
        for (int i = 1; i < str.length(); ++i) {
            char c = str.charAt(i);
            for (char aChar : chars.toCharArray()) {
                if (aChar != c) continue;
                return i;
            }
        }
        return -1;
    }

    private static String trimDecimal(double d) {
        String str = String.valueOf(d);
        if (str.endsWith(".0")) {
            return str.substring(0, str.length() - 2);
        }
        return str;
    }
}

