/*
 * Decompiled with CFR 0.152.
 */
package com.ontey.execution;

import com.ontey.Main;
import com.ontey.execution.Evaluation;
import com.ontey.execution.MacroStrings;
import com.ontey.files.Config;
import com.ontey.holder.ActionHolders;
import com.ontey.holder.Placeholders;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Formattation {
    static String formatCommand(CommandSender sender, String str, String[] args) {
        if (str == null) {
            return "";
        }
        if (str.startsWith(Config.ph("no replace"))) {
            return str.substring(Config.ph("no replace").length());
        }
        str = ActionHolders.apply(sender, str, args);
        str = Formattation.replacePlaceholders(sender, str, args);
        return Formattation.translateColorCodes(str);
    }

    public static String formatMessage(String message, CommandSender sender, String[] args) {
        String str;
        if (message == null) {
            return "";
        }
        String string = str = sender instanceof ConsoleCommandSender && Config.REMOVE_COLORS_IN_CONSOLE ? Formattation.removeColorCodes(message) : Formattation.translateColorCodes(message);
        if (str.startsWith(Config.ph("no replace"))) {
            str = str.substring(Config.ph("no replace").length());
        }
        str = Formattation.replacePlaceholders(sender, str, args);
        return str;
    }

    static String replacePlaceholders(CommandSender sender, @NotNull String str, String[] args) {
        if (str == null) {
            Formattation.$$$reportNull$$$0(0);
        }
        str = Formattation.replacePAPI(sender, str);
        str = Placeholders.apply(sender, str);
        str = str.replace(Config.ph("args-length"), Evaluation.str(args.length));
        return MacroStrings.replaceMacroStrings(str, sender, args);
    }

    static String translateColorCodes(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("(?<!&)&([0-9a-fk-or])", "\u00a7$1").replaceAll("&&([0-9a-fk-or])", "&$1");
    }

    static String removeColorCodes(String str) {
        return str.replaceAll("(?<!&)&([0-9a-fk-or])", "").replaceAll("&&([0-9a-fk-or])", "&$1");
    }

    static String replacePAPI(CommandSender sender, String str) {
        if (Main.papi && sender instanceof Player) {
            Player player = (Player)sender;
            return PlaceholderAPI.setPlaceholders((Player)player, (String)str);
        }
        return str;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/ontey/execution/Formattation", "replacePlaceholders"));
    }
}

