/*
 * Decompiled with CFR 0.152.
 */
package com.ontey.execution;

import com.ontey.execution.Evaluation;
import com.ontey.execution.Formattation;
import com.ontey.execution.Replacement;
import com.ontey.types.AdvancedBroadcast;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Execution {
    public static void sendMessages(List<String> messages, CommandSender sender, String[] args) {
        if (messages.isEmpty()) {
            return;
        }
        for (String msg : messages) {
            if (msg.isEmpty()) continue;
            sender.sendMessage(Formattation.formatMessage(Replacement.replaceArgs(msg, args), sender, args));
        }
    }

    public static void runCommands(List<String> commands, CommandSender sender, String[] args) {
        Evaluation.resolveConditions(sender, args, commands);
        if (commands.isEmpty()) {
            return;
        }
        for (String cmd : commands) {
            String formatted = Formattation.formatCommand(sender, Replacement.replaceArgs(cmd, args), args);
            if (formatted.isEmpty()) continue;
            Bukkit.dispatchCommand((CommandSender)sender, (String)formatted);
        }
    }

    public static void sendBroadcasts(List<String> broadcasts, CommandSender sender, String[] args) {
        if (broadcasts.isEmpty()) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            for (String bc : broadcasts) {
                if (bc.isEmpty()) continue;
                player.sendMessage(Formattation.formatMessage(Replacement.replaceArgs(bc, args), sender, args));
            }
        }
    }

    public static void sendAdvancedBroadcast(AdvancedBroadcast advancedBroadcast, CommandSender sender, String[] args) {
        Location location;
        if (advancedBroadcast == null) {
            return;
        }
        List<String> permission = advancedBroadcast.permission;
        List<String> condition = advancedBroadcast.condition;
        double range = advancedBroadcast.range(sender, args);
        if (sender instanceof Player) {
            Player p = (Player)sender;
            location = p.getLocation();
        } else {
            location = null;
        }
        Location senderLoc = location;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (permission != null && !Execution.hasPermissions(player, permission) || !Evaluation.evalConditions(condition, sender, args) || range != -1.0 && senderLoc != null && (!player.getWorld().equals((Object)senderLoc.getWorld()) || player.getLocation().distance(senderLoc) > range)) continue;
            for (String msg : advancedBroadcast.broadcast) {
                player.sendMessage(Formattation.formatMessage(msg, sender, args));
            }
        }
    }

    static boolean hasPermissions(Player player, List<String> permissions) {
        for (String perm : permissions) {
            if (player.hasPermission(perm)) continue;
            return false;
        }
        return true;
    }
}

