/*
 * Decompiled with CFR 0.152.
 */
package dev.themeinerlp.faweschematiccloud.util;

import com.intellectualsites.arkitektonika.Arkitektonika;
import com.intellectualsites.arkitektonika.SchematicKeys;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import dev.themeinerlp.faweschematiccloud.FAWESchematicCloud;
import dev.themeinerlp.faweschematiccloud.util.SchematicHolder;
import dev.themeinerlp.faweschematiccloud.util.SchematicUploadResult;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0016\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\tH\u0002J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Ldev/themeinerlp/faweschematiccloud/util/SchematicUploader;", "", "faweSchematicCloud", "Ldev/themeinerlp/faweschematiccloud/FAWESchematicCloud;", "<init>", "(Ldev/themeinerlp/faweschematiccloud/FAWESchematicCloud;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "tempDir", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "arkitektonika", "Lcom/intellectualsites/arkitektonika/Arkitektonika;", "getArkitektonika", "()Lcom/intellectualsites/arkitektonika/Arkitektonika;", "arkitektonika$delegate", "Lkotlin/Lazy;", "upload", "Ljava/util/concurrent/CompletableFuture;", "Ldev/themeinerlp/faweschematiccloud/util/SchematicUploadResult;", "holder", "Ldev/themeinerlp/faweschematiccloud/util/SchematicHolder;", "wrapIntoResult", "schematicKeys", "Lcom/intellectualsites/arkitektonika/SchematicKeys;", "uploadAndDelete", "file", "writeToTempFile", "writeSchematic", "", "outputStream", "Ljava/io/OutputStream;", "FaweSchematicCloud"})
public final class SchematicUploader {
    @NotNull
    private final FAWESchematicCloud faweSchematicCloud;
    @NotNull
    private final Logger logger;
    private final Path tempDir;
    @NotNull
    private final Lazy arkitektonika$delegate;

    public SchematicUploader(@NotNull FAWESchematicCloud faweSchematicCloud) {
        Intrinsics.checkNotNullParameter((Object)faweSchematicCloud, "faweSchematicCloud");
        this.faweSchematicCloud = faweSchematicCloud;
        Logger logger = LogManager.getLogger((String)("FAWESchematicCloud/" + SchematicUploader.class.getSimpleName()));
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        this.logger = logger;
        this.tempDir = this.faweSchematicCloud.getDataFolder().toPath();
        this.arkitektonika$delegate = LazyKt.lazy(() -> SchematicUploader.arkitektonika_delegate$lambda$0(this));
    }

    private final Arkitektonika getArkitektonika() {
        Lazy lazy = this.arkitektonika$delegate;
        return (Arkitektonika)lazy.getValue();
    }

    @NotNull
    public final CompletableFuture<SchematicUploadResult> upload(@NotNull SchematicHolder holder) {
        Intrinsics.checkNotNullParameter(holder, "holder");
        CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(holder).thenApply(arg_0 -> SchematicUploader.upload$lambda$1(new Function1<SchematicHolder, Path>((Object)this){

            public final Path invoke(SchematicHolder p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return SchematicUploader.access$writeToTempFile((SchematicUploader)this.receiver, p0);
            }
        }, arg_0))).thenApply(arg_0 -> SchematicUploader.upload$lambda$2(new Function1<Path, SchematicKeys>((Object)this){

            public final SchematicKeys invoke(Path p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return SchematicUploader.access$uploadAndDelete((SchematicUploader)this.receiver, p0);
            }
        }, arg_0))).thenApply(arg_0 -> SchematicUploader.upload$lambda$3(new Function1<SchematicKeys, SchematicUploadResult>((Object)this){

            public final SchematicUploadResult invoke(SchematicKeys p0) {
                return SchematicUploader.access$wrapIntoResult((SchematicUploader)this.receiver, p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(completionStage, "thenApply(...)");
        return completionStage;
    }

    private final SchematicUploadResult wrapIntoResult(SchematicKeys schematicKeys) {
        if (schematicKeys == null) {
            return new SchematicUploadResult(false, null, null, null, null, 30, null);
        }
        String string = this.faweSchematicCloud.getConfig().getString("arkitektonika.downloadUrl");
        if (string == null) {
            throw new NullPointerException("Arkitektonika Download Url not found");
        }
        String string2 = schematicKeys.getAccessKey();
        Intrinsics.checkNotNullExpressionValue(string2, "getAccessKey(...)");
        String apiDownload = StringsKt.replace$default(string, "{key}", string2, false, 4, null);
        String string3 = this.faweSchematicCloud.getConfig().getString("arkitektonika.deleteUrl");
        if (string3 == null) {
            throw new NullPointerException("Arkitektonika Delete Url not found");
        }
        String string4 = schematicKeys.getDeletionKey();
        Intrinsics.checkNotNullExpressionValue(string4, "getDeletionKey(...)");
        String apiDelete = StringsKt.replace$default(string3, "{key}", string4, false, 4, null);
        String string5 = this.faweSchematicCloud.getConfig().getString("web.downloadUrl");
        if (string5 == null) {
            throw new NullPointerException("Web Download Url not found");
        }
        String string6 = schematicKeys.getAccessKey();
        Intrinsics.checkNotNullExpressionValue(string6, "getAccessKey(...)");
        String download = StringsKt.replace$default(string5, "{key}", string6, false, 4, null);
        String string7 = this.faweSchematicCloud.getConfig().getString("web.deleteUrl");
        if (string7 == null) {
            throw new NullPointerException("Web Delete Url not found");
        }
        String string8 = schematicKeys.getDeletionKey();
        Intrinsics.checkNotNullExpressionValue(string8, "getDeletionKey(...)");
        String delete = StringsKt.replace$default(string7, "{key}", string8, false, 4, null);
        return new SchematicUploadResult(true, apiDownload, apiDelete, download, delete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SchematicKeys uploadAndDelete(Path file) {
        SchematicKeys schematicKeys;
        try {
            CompletableFuture<SchematicKeys> completableFuture = this.getArkitektonika().upload(file.toFile());
            Intrinsics.checkNotNullExpressionValue(completableFuture, "upload(...)");
            CompletableFuture<SchematicKeys> upload2 = completableFuture;
            schematicKeys = upload2.join();
        }
        catch (CompletionException e) {
            this.logger.error("Failed to upload schematic", (Throwable)e);
            schematicKeys = null;
        }
        finally {
            try {
                Files.delete(file);
            }
            catch (IOException e) {
                this.logger.error("Failed to delete temporary file {}", (Object)file, (Object)e);
            }
        }
        return schematicKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path writeToTempFile(SchematicHolder holder) {
        try {
            Path tempFile = Files.createTempFile(this.tempDir, null, null, new FileAttribute[0]);
            Closeable closeable = Files.newOutputStream(tempFile, new OpenOption[0]);
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                this.writeSchematic(holder, it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            Intrinsics.checkNotNull(tempFile);
            return tempFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private final void writeSchematic(SchematicHolder holder, OutputStream outputStream) {
        Clipboard cb = holder.getClipboard().getClipboard();
        holder.getFormat().write(outputStream, cb);
    }

    private static final Arkitektonika arkitektonika_delegate$lambda$0(SchematicUploader this$0) {
        String string = this$0.faweSchematicCloud.getConfig().getString("arkitektonika.backendUrl");
        if (string == null) {
            throw new NullPointerException("Arkitektonika Backend Url not found");
        }
        String backendUrl = string;
        Arkitektonika arkitektonika = Arkitektonika.builder().withUrl(backendUrl).build();
        Intrinsics.checkNotNullExpressionValue(arkitektonika, "build(...)");
        return arkitektonika;
    }

    private static final Path upload$lambda$1(Function1 $tmp0, Object p0) {
        return (Path)$tmp0.invoke(p0);
    }

    private static final SchematicKeys upload$lambda$2(Function1 $tmp0, Object p0) {
        return (SchematicKeys)$tmp0.invoke(p0);
    }

    private static final SchematicUploadResult upload$lambda$3(Function1 $tmp0, Object p0) {
        return (SchematicUploadResult)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Path access$writeToTempFile(SchematicUploader $this, SchematicHolder holder) {
        return $this.writeToTempFile(holder);
    }

    public static final /* synthetic */ SchematicKeys access$uploadAndDelete(SchematicUploader $this, Path file) {
        return $this.uploadAndDelete(file);
    }

    public static final /* synthetic */ SchematicUploadResult access$wrapIntoResult(SchematicUploader $this, SchematicKeys schematicKeys) {
        return $this.wrapIntoResult(schematicKeys);
    }
}

