/*
 * Decompiled with CFR 0.152.
 */
package com.intellectualsites.arkitektonika;

import com.intellectualsites.arkitektonika.ApiClient;
import com.intellectualsites.arkitektonika.ApiVersion;
import com.intellectualsites.arkitektonika.ClientFactory;
import com.intellectualsites.arkitektonika.ResourceStatus;
import com.intellectualsites.arkitektonika.Schematic;
import com.intellectualsites.arkitektonika.SchematicKeys;
import java.io.File;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;

public class Arkitektonika {
    private static final ClientFactory clientFactory = new ClientFactory();
    private final ApiClient client;
    private final ExecutorService executorService;

    private Arkitektonika(@NotNull String url, @NotNull ApiVersion apiVersion, @NotNull ExecutorService executorService) {
        this.client = clientFactory.getClient(apiVersion, url);
        this.executorService = executorService;
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public ApiClient getClient() {
        return this.client;
    }

    @NotNull
    public CompletableFuture<Boolean> isCompatible() {
        return this.client.checkCompatibility(this.executorService);
    }

    @NotNull
    public CompletableFuture<SchematicKeys> upload(@NotNull File file) {
        return this.client.upload(file, this.executorService);
    }

    @NotNull
    public CompletableFuture<ResourceStatus> checkStatus(@NotNull String key) {
        return this.client.checkStatus(key, this.executorService);
    }

    @NotNull
    public CompletableFuture<Boolean> delete(@NotNull String key) {
        return this.client.delete(key, this.executorService);
    }

    @NotNull
    public CompletableFuture<Schematic> download(@NotNull String key) {
        return this.client.download(key, this.executorService);
    }

    public static final class Builder {
        private String url;
        private ApiVersion version = ApiVersion.V1_0_0;
        private ExecutorService executorService = Executors.newCachedThreadPool();

        private Builder() {
        }

        @NotNull
        public Builder withUrl(@NotNull String url) {
            this.url = Objects.requireNonNull(url);
            return this;
        }

        @NotNull
        public Builder withVersion(@NotNull ApiVersion version) {
            this.version = Objects.requireNonNull(version);
            return this;
        }

        @NotNull
        public Builder withExecutorService(@NotNull ExecutorService executorService) {
            this.executorService = Objects.requireNonNull(executorService);
            return this;
        }

        @NotNull
        public Arkitektonika build() {
            if (this.url == null) {
                throw new NullPointerException("No URL was provided");
            }
            return new Arkitektonika(this.url, this.version, this.executorService);
        }
    }
}

