/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.brigadier;

import cloud.commandframework.Command;
import cloud.commandframework.CommandManager;
import cloud.commandframework.CommandTree;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.StaticArgument;
import cloud.commandframework.arguments.compound.CompoundArgument;
import cloud.commandframework.arguments.compound.FlagArgument;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.arguments.parser.MappedArgumentParser;
import cloud.commandframework.arguments.standard.BooleanArgument;
import cloud.commandframework.arguments.standard.ByteArgument;
import cloud.commandframework.arguments.standard.DoubleArgument;
import cloud.commandframework.arguments.standard.FloatArgument;
import cloud.commandframework.arguments.standard.IntegerArgument;
import cloud.commandframework.arguments.standard.LongArgument;
import cloud.commandframework.arguments.standard.ShortArgument;
import cloud.commandframework.arguments.standard.StringArgument;
import cloud.commandframework.arguments.standard.StringArrayArgument;
import cloud.commandframework.brigadier.BrigadierMapping;
import cloud.commandframework.brigadier.BrigadierMappingBuilder;
import cloud.commandframework.brigadier.argument.WrappedBrigadierParser;
import cloud.commandframework.permission.CommandPermission;
import cloud.commandframework.permission.Permission;
import cloud.commandframework.types.tuples.Pair;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CloudBrigadierManager<C, S> {
    private static final SuggestionProvider<?> DELEGATE_TO_CLOUD = (c, b) -> b.buildFuture();
    private final Map<Class<?>, BrigadierMapping<C, ?, S>> mappers = new HashMap();
    private final Map<@NonNull Class<?>, @NonNull Supplier<@Nullable ArgumentType<?>>> defaultArgumentTypeSuppliers = new HashMap();
    private final Supplier<cloud.commandframework.context.CommandContext<C>> dummyContextProvider;
    private final CommandManager<C> commandManager;
    private Function<S, C> brigadierCommandSenderMapper;
    private Function<C, S> backwardsBrigadierCommandSenderMapper;

    static <T> SuggestionProvider<T> delegateSuggestions() {
        return DELEGATE_TO_CLOUD;
    }

    public CloudBrigadierManager(@NonNull CommandManager<C> commandManager, @NonNull Supplier<@NonNull cloud.commandframework.context.CommandContext<C>> dummyContextProvider) {
        this.commandManager = commandManager;
        this.dummyContextProvider = dummyContextProvider;
        this.registerInternalMappings();
        commandManager.registerCommandPreProcessor(ctx -> {
            if (this.backwardsBrigadierCommandSenderMapper != null) {
                ctx.getCommandContext().store("_cloud_brigadier_native_sender", this.backwardsBrigadierCommandSenderMapper.apply(ctx.getCommandContext().getSender()));
            }
        });
    }

    private void registerInternalMappings() {
        this.registerMapping(new TypeToken<ByteArgument.ByteParser<C>>(){}, builder -> builder.to(argument -> IntegerArgumentType.integer(argument.getMin(), argument.getMax())));
        this.registerMapping(new TypeToken<ShortArgument.ShortParser<C>>(){}, builder -> builder.to(argument -> IntegerArgumentType.integer(argument.getMin(), argument.getMax())));
        this.registerMapping(new TypeToken<IntegerArgument.IntegerParser<C>>(){}, builder -> builder.to(argument -> {
            if (!argument.hasMin() && !argument.hasMax()) {
                return IntegerArgumentType.integer();
            }
            if (argument.hasMin() && !argument.hasMax()) {
                return IntegerArgumentType.integer(argument.getMin());
            }
            if (!argument.hasMin()) {
                return IntegerArgumentType.integer(Integer.MIN_VALUE, argument.getMax());
            }
            return IntegerArgumentType.integer(argument.getMin(), argument.getMax());
        }));
        this.registerMapping(new TypeToken<FloatArgument.FloatParser<C>>(){}, builder -> builder.to(argument -> {
            if (!argument.hasMin() && !argument.hasMax()) {
                return FloatArgumentType.floatArg();
            }
            if (argument.hasMin() && !argument.hasMax()) {
                return FloatArgumentType.floatArg(argument.getMin());
            }
            if (!argument.hasMin()) {
                return FloatArgumentType.floatArg(-3.4028235E38f, argument.getMax());
            }
            return FloatArgumentType.floatArg(argument.getMin(), argument.getMax());
        }));
        this.registerMapping(new TypeToken<DoubleArgument.DoubleParser<C>>(){}, builder -> builder.to(argument -> {
            if (!argument.hasMin() && !argument.hasMax()) {
                return DoubleArgumentType.doubleArg();
            }
            if (argument.hasMin() && !argument.hasMax()) {
                return DoubleArgumentType.doubleArg(argument.getMin());
            }
            if (!argument.hasMin()) {
                return DoubleArgumentType.doubleArg(-1.7976931348623157E308, argument.getMax());
            }
            return DoubleArgumentType.doubleArg(argument.getMin(), argument.getMax());
        }));
        this.registerMapping(new TypeToken<LongArgument.LongParser<C>>(){}, builder -> builder.to(longParser -> {
            if (!longParser.hasMin() && !longParser.hasMax()) {
                return LongArgumentType.longArg();
            }
            if (longParser.hasMin() && !longParser.hasMax()) {
                return LongArgumentType.longArg(longParser.getMin());
            }
            if (!longParser.hasMin()) {
                return LongArgumentType.longArg(Long.MIN_VALUE, longParser.getMax());
            }
            return LongArgumentType.longArg(longParser.getMin(), longParser.getMax());
        }));
        this.registerMapping(new TypeToken<BooleanArgument.BooleanParser<C>>(){}, builder -> builder.toConstant(BoolArgumentType.bool()));
        this.registerMapping(new TypeToken<StringArgument.StringParser<C>>(){}, builder -> builder.cloudSuggestions().to(argument -> {
            switch (argument.getStringMode()) {
                case QUOTED: {
                    return StringArgumentType.string();
                }
                case GREEDY: 
                case GREEDY_FLAG_YIELDING: {
                    return StringArgumentType.greedyString();
                }
            }
            return StringArgumentType.word();
        }));
        this.registerMapping(new TypeToken<FlagArgument.FlagArgumentParser<C>>(){}, builder -> builder.cloudSuggestions().toConstant(StringArgumentType.greedyString()));
        this.registerMapping(new TypeToken<StringArrayArgument.StringArrayParser<C>>(){}, builder -> builder.cloudSuggestions().toConstant(StringArgumentType.greedyString()));
        this.registerMapping(new TypeToken<WrappedBrigadierParser<C, ?>>(){}, builder -> builder.to(WrappedBrigadierParser::getNativeArgument));
    }

    public void brigadierSenderMapper(@NonNull Function<@NonNull S, @Nullable C> mapper) {
        this.brigadierCommandSenderMapper = mapper;
    }

    public @Nullable Function<@NonNull S, @Nullable C> brigadierSenderMapper() {
        return this.brigadierCommandSenderMapper;
    }

    public void backwardsBrigadierSenderMapper(@NonNull Function<@NonNull C, @Nullable S> mapper) {
        this.backwardsBrigadierCommandSenderMapper = mapper;
    }

    public void setNativeNumberSuggestions(boolean nativeNumberSuggestions) {
        this.setNativeSuggestions(new TypeToken<ByteArgument.ByteParser<C>>(){}, nativeNumberSuggestions);
        this.setNativeSuggestions(new TypeToken<ShortArgument.ShortParser<C>>(){}, nativeNumberSuggestions);
        this.setNativeSuggestions(new TypeToken<IntegerArgument.IntegerParser<C>>(){}, nativeNumberSuggestions);
        this.setNativeSuggestions(new TypeToken<FloatArgument.FloatParser<C>>(){}, nativeNumberSuggestions);
        this.setNativeSuggestions(new TypeToken<DoubleArgument.DoubleParser<C>>(){}, nativeNumberSuggestions);
        this.setNativeSuggestions(new TypeToken<LongArgument.LongParser<C>>(){}, nativeNumberSuggestions);
    }

    public <T, K extends ArgumentParser<C, T>> void setNativeSuggestions(@NonNull TypeToken<K> argumentType, boolean nativeSuggestions) throws IllegalArgumentException {
        BrigadierMapping<C, ?, S> pair = this.mappers.get(GenericTypeReflector.erase(argumentType.getType()));
        if (pair == null) {
            throw new IllegalArgumentException("No mapper registered for type: " + GenericTypeReflector.erase(argumentType.getType()).toGenericString());
        }
        this.mappers.put(GenericTypeReflector.erase(argumentType.getType()), pair.withNativeSuggestions(nativeSuggestions));
    }

    @Deprecated
    public <T, K extends ArgumentParser<C, T>, O> void registerMapping(@NonNull TypeToken<K> argumentType, boolean nativeSuggestions, @NonNull Function<@NonNull ? extends K, @NonNull ? extends ArgumentType<O>> mapper) {
        this.registerMapping(argumentType, builder -> {
            builder.to(mapper);
            if (!nativeSuggestions) {
                builder.cloudSuggestions();
            }
        });
    }

    public <K extends ArgumentParser<C, ?>> void registerMapping(@NonNull TypeToken<K> parserType, Consumer<BrigadierMappingBuilder<K, S>> configurer) {
        BrigadierMapping.BuilderImpl builder = new BrigadierMapping.BuilderImpl();
        configurer.accept(builder);
        this.mappers.put(GenericTypeReflector.erase(parserType.getType()), builder.build());
    }

    public void registerDefaultArgumentTypeSupplier(@NonNull Class<?> clazz, @NonNull Supplier<@Nullable ArgumentType<?>> supplier) {
        this.defaultArgumentTypeSuppliers.put(clazz, supplier);
    }

    private <K extends ArgumentParser<C, ?>> @Nullable Pair<@NonNull ArgumentType<?>, @Nullable SuggestionProvider<S>> getArgument(@NonNull TypeToken<?> valueType, @NonNull K argumentParser) {
        Object commandArgument = argumentParser;
        while (commandArgument instanceof MappedArgumentParser) {
            commandArgument = ((MappedArgumentParser)commandArgument).getBaseParser();
        }
        BrigadierMapping<C, ?, S> mapping = this.mappers.get(commandArgument.getClass());
        if (mapping == null || mapping.getMapper() == null) {
            return this.createDefaultMapper(valueType);
        }
        return Pair.of(mapping.getMapper().apply(commandArgument), mapping.makeSuggestionProvider(argumentParser));
    }

    private @NonNull Pair<@NonNull ArgumentType<?>, @Nullable SuggestionProvider<S>> createDefaultMapper(@NonNull TypeToken<?> clazz) {
        Supplier<ArgumentType<?>> argumentTypeSupplier = this.defaultArgumentTypeSuppliers.get(GenericTypeReflector.erase(clazz.getType()));
        @Nullable ArgumentType<?> defaultType = argumentTypeSupplier != null ? argumentTypeSupplier.get() : null;
        if (defaultType != null) {
            return Pair.of(argumentTypeSupplier.get(), null);
        }
        return Pair.of(StringArgumentType.word(), CloudBrigadierManager.delegateSuggestions());
    }

    public @NonNull LiteralCommandNode<S> createLiteralCommandNode(@NonNull String label, @NonNull Command<C> cloudCommand, @NonNull BiPredicate<@NonNull S, @NonNull CommandPermission> permissionChecker, boolean forceRegister, @NonNull com.mojang.brigadier.Command<S> executor) {
        CommandTree.Node node = this.commandManager.commandTree().getNamedNode(cloudCommand.getArguments().get(0).getName());
        SuggestionProvider provider = (context, builder) -> this.buildSuggestions(context, null, (CommandArgument)node.getValue(), builder);
        LiteralArgumentBuilder literalArgumentBuilder = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal(label).requires(sender -> permissionChecker.test(sender, (CommandPermission)node.getNodeMeta().getOrDefault("permission", Permission.empty())));
        if (forceRegister || node.getValue() != null && node.getValue().getOwningCommand() != null) {
            literalArgumentBuilder.executes(executor);
        }
        literalArgumentBuilder.executes(executor);
        CommandNode constructedRoot = literalArgumentBuilder.build();
        for (CommandTree.Node<CommandArgument<C, ?>> child : node.getChildren()) {
            constructedRoot.addChild(this.constructCommandNode(forceRegister, child, permissionChecker, executor, provider).build());
        }
        return constructedRoot;
    }

    public @NonNull LiteralCommandNode<S> createLiteralCommandNode( @NonNull CommandTree.Node<@NonNull CommandArgument<C, ?>> cloudCommand, @NonNull LiteralCommandNode<S> root, @NonNull SuggestionProvider<S> suggestionProvider, @NonNull com.mojang.brigadier.Command<S> executor, @NonNull BiPredicate<@NonNull S, @NonNull CommandPermission> permissionChecker) {
        LiteralArgumentBuilder literalArgumentBuilder = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal(root.getLiteral()).requires(sender -> permissionChecker.test(sender, (CommandPermission)cloudCommand.getNodeMeta().getOrDefault("permission", Permission.empty())));
        if (cloudCommand.getValue() != null && cloudCommand.getValue().getOwningCommand() != null) {
            literalArgumentBuilder.executes(executor);
        }
        CommandNode constructedRoot = literalArgumentBuilder.build();
        for (CommandTree.Node<CommandArgument<C, ?>> child : cloudCommand.getChildren()) {
            constructedRoot.addChild(this.constructCommandNode(true, child, permissionChecker, executor, suggestionProvider).build());
        }
        return constructedRoot;
    }

    private @NonNull ArgumentBuilder<S, ?> constructCommandNode(boolean forceExecutor,  @NonNull CommandTree.Node<CommandArgument<C, ?>> root, @NonNull BiPredicate<@NonNull S, @NonNull CommandPermission> permissionChecker, @NonNull com.mojang.brigadier.Command<S> executor, SuggestionProvider<S> suggestionProvider) {
        Object argumentBuilder;
        if (root.getValue() instanceof CompoundArgument) {
            CompoundArgument compoundArgument = (CompoundArgument)root.getValue();
            Object[] parsers = compoundArgument.getParserTuple().toArray();
            Object[] types = compoundArgument.getTypes().toArray();
            Object[] names = compoundArgument.getNames().toArray();
            ArgumentBuilder[] argumentBuilders = new ArgumentBuilder[parsers.length];
            for (int i = parsers.length - 1; i >= 0; --i) {
                ArgumentParser parser = (ArgumentParser)parsers[i];
                Pair pair = this.getArgument(TypeToken.get((Class)types[i]), parser);
                SuggestionProvider<S> provider = pair.getSecond() == CloudBrigadierManager.delegateSuggestions() ? suggestionProvider : pair.getSecond();
                Object fragmentBuilder = RequiredArgumentBuilder.argument((String)names[i], pair.getFirst()).suggests(provider).requires(sender -> permissionChecker.test(sender, (CommandPermission)root.getNodeMeta().getOrDefault("permission", Permission.empty())));
                argumentBuilders[i] = fragmentBuilder;
                if (forceExecutor || i == parsers.length - 1 && (root.isLeaf() || !root.getValue().isRequired())) {
                    ((ArgumentBuilder)fragmentBuilder).executes(executor);
                }
                if (i + 1 >= parsers.length) continue;
                ((ArgumentBuilder)fragmentBuilder).then(argumentBuilders[i + 1]);
            }
            for (CommandTree.Node<CommandArgument<C, ?>> node2 : root.getChildren()) {
                argumentBuilders[parsers.length - 1].then(this.constructCommandNode(forceExecutor, node2, permissionChecker, executor, suggestionProvider));
            }
            return argumentBuilders[0];
        }
        if (root.getValue() instanceof StaticArgument) {
            argumentBuilder = ((LiteralArgumentBuilder)LiteralArgumentBuilder.literal(root.getValue().getName()).requires(sender -> permissionChecker.test(sender, (CommandPermission)root.getNodeMeta().getOrDefault("permission", Permission.empty())))).executes(executor);
        } else {
            Pair<ArgumentType<?>, SuggestionProvider<S>> pair = this.getArgument(root.getValue().getValueType(), root.getValue().getParser());
            SuggestionProvider provider = pair.getSecond() == CloudBrigadierManager.delegateSuggestions() ? (context, builder) -> this.buildSuggestions(context, root.getParent(), (CommandArgument)root.getValue(), builder) : pair.getSecond();
            argumentBuilder = RequiredArgumentBuilder.argument(root.getValue().getName(), pair.getFirst()).suggests(provider).requires(sender -> permissionChecker.test(sender, (CommandPermission)root.getNodeMeta().getOrDefault("permission", Permission.empty())));
        }
        if (forceExecutor || root.isLeaf() || !root.getValue().isRequired()) {
            ((ArgumentBuilder)argumentBuilder).executes(executor);
        }
        if (root.getChildren().stream().noneMatch(node -> ((CommandArgument)node.getValue()).isRequired())) {
            ((ArgumentBuilder)argumentBuilder).executes(executor);
        }
        for (CommandTree.Node<CommandArgument<C, ?>> node3 : root.getChildren()) {
            ((ArgumentBuilder)argumentBuilder).then(this.constructCommandNode(forceExecutor, node3, permissionChecker, executor, suggestionProvider));
        }
        return argumentBuilder;
    }

    private @NonNull CompletableFuture<Suggestions> buildSuggestions(@Nullable CommandContext<S> senderContext,  @Nullable CommandTree.Node<CommandArgument<C, ?>> parentNode, @NonNull CommandArgument<C, ?> argument, @NonNull SuggestionsBuilder builder) {
        String leading;
        cloud.commandframework.context.CommandContext<C> commandContext;
        String command = builder.getInput();
        if (this.brigadierCommandSenderMapper == null || senderContext == null) {
            commandContext = this.dummyContextProvider.get();
            if (command.startsWith("/")) {
                command = command.substring(1);
            }
        } else {
            C cloudSender = this.brigadierCommandSenderMapper.apply(senderContext.getSource());
            commandContext = new cloud.commandframework.context.CommandContext<C>(true, cloudSender, this.commandManager);
            command = command.substring(CloudBrigadierManager.getNodes(senderContext.getLastChild()).get(0).getSecond().getStart());
        }
        if ((leading = command.split(" ")[0]).contains(":")) {
            command = command.substring(leading.split(":")[0].length() + 1);
        }
        List<String> suggestionsUnfiltered = this.commandManager.suggest(commandContext.getSender(), command);
        ArrayList<String> suggestions = new ArrayList<String>(suggestionsUnfiltered);
        if (parentNode != null) {
            Set siblingLiterals = parentNode.getChildren().stream().map(CommandTree.Node::getValue).flatMap(arg -> arg instanceof StaticArgument ? ((StaticArgument)arg).getAliases().stream() : Stream.empty()).collect(Collectors.toSet());
            suggestions.removeIf(siblingLiterals::contains);
        }
        SuggestionsBuilder suggestionsBuilder = builder;
        int lastIndexOfSpaceInRemainingString = builder.getRemaining().lastIndexOf(32);
        if (lastIndexOfSpaceInRemainingString != -1) {
            suggestionsBuilder = builder.createOffset(builder.getStart() + lastIndexOfSpaceInRemainingString + 1);
        }
        for (String suggestion : suggestions) {
            String tooltip = argument.getName();
            if (!(argument instanceof StaticArgument)) {
                tooltip = argument.isRequired() ? '<' + tooltip + '>' : '[' + tooltip + ']';
            }
            suggestionsBuilder = suggestionsBuilder.suggest(suggestion, (Message)new LiteralMessage(tooltip));
        }
        return suggestionsBuilder.buildFuture();
    }

    private static <S> List<Pair<CommandNode<S>, StringRange>> getNodes(CommandContext<S> commandContext) {
        try {
            Method getNodesMethod = commandContext.getClass().getDeclaredMethod("getNodes", new Class[0]);
            Object nodes = getNodesMethod.invoke(commandContext, new Object[0]);
            if (nodes instanceof List) {
                return ParsedCommandNodeHandler.toPairList((List)nodes);
            }
            if (nodes instanceof Map) {
                return ((Map)nodes).entrySet().stream().map(entry -> Pair.of((CommandNode)entry.getKey(), (StringRange)entry.getValue())).collect(Collectors.toList());
            }
            throw new IllegalStateException();
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static final class ParsedCommandNodeHandler {
        private ParsedCommandNodeHandler() {
        }

        private static <S> List<Pair<CommandNode<S>, StringRange>> toPairList(List<?> nodes) {
            return nodes.stream().map(n -> Pair.of(n.getNode(), n.getRange())).collect(Collectors.toList());
        }
    }
}

