/*
 * Decompiled with CFR 0.152.
 */
package cloud.commandframework.arguments.standard;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.parser.ArgumentParseResult;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.context.CommandContext;
import io.leangen.geantyref.TypeToken;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@API(status=API.Status.STABLE)
public final class StringArrayArgument<C>
extends CommandArgument<C, String[]> {
    private StringArrayArgument(boolean required, @NonNull String name, @Nullable BiFunction<CommandContext<C>, String, List<String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription, boolean flagYielding) {
        super(required, name, new StringArrayParser(flagYielding), "", TypeToken.get(String[].class), suggestionsProvider, defaultDescription);
    }

    public static <C> @NonNull StringArrayArgument<C> of(@NonNull String name, @NonNull BiFunction<CommandContext<C>, String, List<String>> suggestionsProvider) {
        return new StringArrayArgument<C>(true, name, suggestionsProvider, ArgumentDescription.empty(), false);
    }

    @API(status=API.Status.STABLE, since="1.7.0")
    public static <C> @NonNull StringArrayArgument<C> of(@NonNull String name, boolean flagYielding, @NonNull BiFunction<CommandContext<C>, String, List<String>> suggestionsProvider) {
        return new StringArrayArgument<C>(true, name, suggestionsProvider, ArgumentDescription.empty(), flagYielding);
    }

    public static <C> @NonNull StringArrayArgument<C> optional(@NonNull String name, @NonNull BiFunction<CommandContext<C>, String, List<String>> suggestionsProvider) {
        return new StringArrayArgument<C>(false, name, suggestionsProvider, ArgumentDescription.empty(), false);
    }

    @API(status=API.Status.STABLE, since="1.7.0")
    public static <C> @NonNull StringArrayArgument<C> optional(@NonNull String name, boolean flagYielding, @NonNull BiFunction<CommandContext<C>, String, List<String>> suggestionsProvider) {
        return new StringArrayArgument<C>(false, name, suggestionsProvider, ArgumentDescription.empty(), flagYielding);
    }

    @API(status=API.Status.STABLE)
    public static final class StringArrayParser<C>
    implements ArgumentParser<C, String[]> {
        private static final Pattern FLAG_PATTERN = Pattern.compile("(-[A-Za-z_\\-0-9])|(--[A-Za-z_\\-0-9]*)");
        private final boolean flagYielding;

        public StringArrayParser() {
            this.flagYielding = false;
        }

        @API(status=API.Status.STABLE, since="1.7.0")
        public StringArrayParser(boolean flagYielding) {
            this.flagYielding = flagYielding;
        }

        @Override
        public @NonNull ArgumentParseResult<String @NonNull []> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            if (this.flagYielding) {
                String string;
                LinkedList<String> result = new LinkedList<String>();
                int size = inputQueue.size();
                for (int i = 0; i < size && (string = inputQueue.peek()) != null && !FLAG_PATTERN.matcher(string).matches(); ++i) {
                    inputQueue.remove();
                    result.add(string);
                }
                return ArgumentParseResult.success(result.toArray(new String[0]));
            }
            String[] result = new String[inputQueue.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = inputQueue.remove();
            }
            return ArgumentParseResult.success(result);
        }
    }
}

