/*
 * Decompiled with CFR 0.152.
 */
package dev.themeinerlp.attollo.service;

import com.github.zafarkhaja.semver.Version;
import dev.themeinerlp.attollo.Attollo;
import dev.themeinerlp.attollo.ConstantsKt;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpResponse;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aJ\"\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\n\u0010\u001b\u001a\u0004\u0018\u00010\fH\u0002J\u0006\u0010\u001c\u001a\u00020\u0014R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \b*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ldev/themeinerlp/attollo/service/UpdateService;", "Ljava/lang/Runnable;", "plugin", "Ldev/themeinerlp/attollo/Attollo;", "<init>", "(Ldev/themeinerlp/attollo/Attollo;)V", "hangarClient", "Ljava/net/http/HttpClient;", "kotlin.jvm.PlatformType", "LOGGER", "Lorg/slf4j/Logger;", "localVersion", "Lcom/github/zafarkhaja/semver/Version;", "remoteVersion", "scheduler", "Lorg/bukkit/scheduler/BukkitTask;", "Lorg/jetbrains/annotations/NotNull;", "DOWNLOAD_URL", "", "run", "", "notifyConsole", "logger", "Lnet/kyori/adventure/text/logger/slf4j/ComponentLogger;", "notifyPlayer", "player", "Lorg/bukkit/entity/Player;", "getNewerVersion", "shutdown", "Attollo"})
public final class UpdateService
implements Runnable {
    private final HttpClient hangarClient;
    private final Logger LOGGER;
    private final Version localVersion;
    @Nullable
    private Version remoteVersion;
    @NotNull
    private final BukkitTask scheduler;
    @NotNull
    private final String DOWNLOAD_URL;

    public UpdateService(@NotNull Attollo plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.hangarClient = HttpClient.newBuilder().build();
        this.LOGGER = LoggerFactory.getLogger(UpdateService.class);
        this.localVersion = Version.parse(plugin.getPluginMeta().getVersion());
        BukkitTask bukkitTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, (Runnable)this, 0L, 216000L);
        Intrinsics.checkNotNullExpressionValue(bukkitTask, "runTaskTimerAsynchronously(...)");
        this.scheduler = bukkitTask;
        this.DOWNLOAD_URL = "https://hangar.papermc.io/OneLiteFeather/Attollo/versions/%s";
    }

    @Override
    public void run() {
        Version remoteVersion = this.getNewerVersion();
        if (remoteVersion != null) {
            this.remoteVersion = remoteVersion;
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (!onlinePlayer.isOp() && !onlinePlayer.hasPermission("attollo.update")) continue;
                Version version = this.localVersion;
                Intrinsics.checkNotNullExpressionValue(version, "localVersion");
                Intrinsics.checkNotNull(onlinePlayer);
                this.notifyPlayer(version, remoteVersion, onlinePlayer);
            }
        }
    }

    public final void notifyConsole(@NotNull ComponentLogger logger) {
        Intrinsics.checkNotNullParameter(logger, "logger");
        if (this.remoteVersion != null) {
            Version version = this.remoteVersion;
            boolean bl = version != null ? version.isHigherThan(this.localVersion) : false;
            if (bl) {
                MiniMessage miniMessage = MiniMessage.miniMessage();
                TagResolver[] tagResolverArray = new TagResolver[3];
                tagResolverArray[0] = Placeholder.component("local_version", Component.text(this.localVersion.toString()));
                tagResolverArray[1] = Placeholder.component("remote_version", Component.text(String.valueOf(this.remoteVersion)));
                String string = this.DOWNLOAD_URL;
                Object[] objectArray = new Object[]{String.valueOf(this.remoteVersion)};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                tagResolverArray[2] = Placeholder.component("download_url", Component.text(string2));
                logger.warn(miniMessage.deserialize("<yellow>Your version (<local_version>) is older than our latest published version (<remote_version>). Please update as soon as possible to get continued support. Or use this link <download_url>.", tagResolverArray));
            }
        }
    }

    public final void notifyPlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (this.remoteVersion != null) {
            Version version = this.remoteVersion;
            boolean bl = version != null ? version.isHigherThan(this.localVersion) : false;
            if (bl) {
                Version version2 = this.localVersion;
                Intrinsics.checkNotNullExpressionValue(version2, "localVersion");
                this.notifyPlayer(version2, this.remoteVersion, player);
            }
        }
    }

    private final void notifyPlayer(Version localVersion, Version remoteVersion, Player player) {
        MiniMessage miniMessage = MiniMessage.miniMessage();
        TagResolver[] tagResolverArray = new TagResolver[3];
        tagResolverArray[0] = Placeholder.component("local_version", Component.text(localVersion.toString()));
        tagResolverArray[1] = Placeholder.component("remote_version", Component.text(String.valueOf(remoteVersion)));
        StyleBuilderApplicable[] styleBuilderApplicableArray = new StyleBuilderApplicable[1];
        String string = this.DOWNLOAD_URL;
        Object[] objectArray = new Object[]{String.valueOf(remoteVersion)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        styleBuilderApplicableArray[0] = ClickEvent.openUrl(string2);
        tagResolverArray[2] = Placeholder.styling("download_url", styleBuilderApplicableArray);
        player.sendMessage(miniMessage.deserialize("<yellow><download_url>Your version (<local_version>) is older than our latest published version (<remote_version>). Please update as soon as possible to get continued support. Or click me to get on the download page!", tagResolverArray));
    }

    private final Version getNewerVersion() {
        try {
            HttpResponse<String> httpResponse = this.hangarClient.send(ConstantsKt.getLATEST_RELEASE_VERSION_REQUEST(), HttpResponse.BodyHandlers.ofString());
            Version remoteVersion = Version.parse(httpResponse.body());
            if (remoteVersion.isHigherThan(this.localVersion)) {
                return remoteVersion;
            }
        }
        catch (IOException e) {
            this.LOGGER.error("Something went wrong to check updates", (Throwable)e);
        }
        catch (InterruptedException e) {
            this.LOGGER.error("Something went wrong to check updates", (Throwable)e);
        }
        return null;
    }

    public final void shutdown() {
        this.hangarClient.shutdownNow();
        this.scheduler.cancel();
    }
}

