/*
 * Decompiled with CFR 0.152.
 */
package dev.themeinerlp.attollo.listener;

import dev.themeinerlp.attollo.Attollo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0007J\u001a\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ldev/themeinerlp/attollo/listener/AttolloListener;", "Lorg/bukkit/event/Listener;", "attollo", "Ldev/themeinerlp/attollo/Attollo;", "<init>", "(Ldev/themeinerlp/attollo/Attollo;)V", "onUp", "", "event", "Lorg/bukkit/event/player/PlayerMoveEvent;", "onDown", "Lorg/bukkit/event/player/PlayerToggleSneakEvent;", "handleElevator", "player", "Lorg/bukkit/entity/Player;", "up", "", "Attollo"})
@SourceDebugExtension(value={"SMAP\nAttolloListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttolloListener.kt\ndev/themeinerlp/attollo/listener/AttolloListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1563#2:62\n1634#2,3:63\n295#2,2:66\n1563#2:68\n1634#2,3:69\n295#2,2:72\n*S KotlinDebug\n*F\n+ 1 AttolloListener.kt\ndev/themeinerlp/attollo/listener/AttolloListener\n*L\n42#1:62\n42#1:63,3\n45#1:66,2\n47#1:68\n47#1:69,3\n49#1:72,2\n*E\n"})
public final class AttolloListener
implements Listener {
    @NotNull
    private final Attollo attollo;

    public AttolloListener(@NotNull Attollo attollo) {
        Intrinsics.checkNotNullParameter((Object)attollo, "attollo");
        this.attollo = attollo;
    }

    @EventHandler
    public final void onUp(@NotNull PlayerMoveEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        if (event.getTo().getY() <= event.getFrom().getY()) {
            return;
        }
        if (event.getTo().getY() - event.getFrom().getY() <= 0.125) {
            return;
        }
        this.handleElevator(player2, true);
    }

    @EventHandler
    public final void onDown(@NotNull PlayerToggleSneakEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        if (!player2.isSneaking()) {
            return;
        }
        AttolloListener.handleElevator$default(this, player2, false, 2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void handleElevator(Player player, boolean up) {
        Location location;
        if (!player.hasPermission("attollo.use")) {
            return;
        }
        Location location2 = player.getLocation().subtract(0.0, 1.0, 0.0);
        Intrinsics.checkNotNullExpressionValue(location2, "subtract(...)");
        Location location3 = location2;
        Block block = location3.getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        if (block2.getType() != this.attollo.getElevatorBlock()) {
            return;
        }
        World world = block2.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        World world2 = world;
        int height = world2.getMaxHeight();
        int depth = world2.getMinHeight();
        Location location4 = block2.getLocation();
        Intrinsics.checkNotNullExpressionValue(location4, "getLocation(...)");
        Location blockLocation = location4;
        if (up) {
            Object v4;
            block9: {
                $this$map$iv = new IntRange(blockLocation.getBlockY() + 1, height);
                $i$f$map = false;
                Iterable iterable = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    var20_24 = destination$iv$iv;
                    boolean bl = false;
                    var20_24.add(world2.getBlockAt(blockLocation.getBlockX(), it, blockLocation.getBlockZ()));
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Block it = (Block)element$iv;
                    boolean bl = false;
                    if (!(it.getType() == this.attollo.getElevatorBlock())) continue;
                    v4 = element$iv;
                    break block9;
                }
                v4 = null;
            }
            var10_25 = v4;
            if (var10_25 == null || ($this$firstOrNull$iv = var10_25.getLocation()) == null) return;
            location = $this$firstOrNull$iv;
        } else {
            Location location5;
            Object v6;
            block10: {
                $this$map$iv = RangesKt.downTo(blockLocation.getBlockY() - 1, depth);
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator bl = $this$mapTo$iv$iv.iterator();
                while (bl.hasNext()) {
                    it = item$iv$iv = ((IntIterator)bl).nextInt();
                    var20_24 = destination$iv$iv;
                    boolean bl2 = false;
                    var20_24.add(world2.getBlockAt(blockLocation.getBlockX(), it, blockLocation.getBlockZ()));
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Block it = (Block)element$iv;
                    boolean bl3 = false;
                    if (!(it.getType() == this.attollo.getElevatorBlock())) continue;
                    v6 = element$iv;
                    break block10;
                }
                v6 = null;
            }
            var10_25 = v6;
            if (var10_25 == null || (location5 = var10_25.getLocation()) == null) return;
            location = location5;
        }
        Location found = location;
        found.setYaw(location3.getYaw());
        found.setPitch(location3.getPitch());
        Location location6 = found.clone().add(0.5, 1.0, 0.5);
        Intrinsics.checkNotNullExpressionValue(location6, "add(...)");
        Location modifiedLocation = location6;
        if (modifiedLocation.getBlock().getType() != Material.AIR) {
            return;
        }
        player.teleportAsync(modifiedLocation);
    }

    static /* synthetic */ void handleElevator$default(AttolloListener attolloListener, Player player, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        attolloListener.handleElevator(player, bl);
    }
}

