/*
 * Decompiled with CFR 0.152.
 */
package net.onelitefeather.antiredstoneclockremastered.service.notification;

import java.util.List;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.onelitefeather.antiredstoneclockremastered.AntiRedstoneClockRemastered;
import net.onelitefeather.antiredstoneclockremastered.service.api.NotificationService;
import net.onelitefeather.antiredstoneclockremastered.service.api.RegionService;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SignNotificationService
implements NotificationService {
    private static final ComponentLogger LOGGER = ComponentLogger.logger(SignNotificationService.class);
    private final AntiRedstoneClockRemastered plugin;
    private final NotificationService notificationService;
    private final RegionService regionService;
    private final FixedMetadataValue metaValue;

    public SignNotificationService(@NotNull AntiRedstoneClockRemastered plugin, @Nullable NotificationService notificationService, @NotNull RegionService regionService) {
        this.plugin = plugin;
        this.notificationService = notificationService;
        this.regionService = regionService;
        this.metaValue = new FixedMetadataValue((Plugin)plugin, (Object)"arcr-sign");
        if (this.isEnabled()) {
            this.warnForTooLongText();
        }
    }

    private void warnForTooLongText() {
        int size = this.plugin.getConfig().getStringList("notification.sign.back").size();
        if (size > 4) {
            LOGGER.warn("Sign notification 'back' side has too many lines: {}", (Object)size);
        }
        if ((size = this.plugin.getConfig().getStringList("notification.sign.front").size()) > 4) {
            LOGGER.warn("Sign notification 'front' side has too many lines: {}", (Object)size);
        }
        this.plugin.getConfig().getStringList("notification.sign.back").stream().map(arg_0 -> ((MiniMessage)MiniMessage.miniMessage()).stripTags(arg_0)).filter(this::isLineToLongForSign).forEach(line -> LOGGER.warn("Sign notification line is too long for back side: {}", line));
        this.plugin.getConfig().getStringList("notification.sign.front").stream().map(arg_0 -> ((MiniMessage)MiniMessage.miniMessage()).stripTags(arg_0)).filter(this::isLineToLongForSign).forEach(line -> LOGGER.warn("Sign notification line is too long for front side: {}", line));
    }

    private boolean isLineToLongForSign(String line) {
        return line.length() > 16;
    }

    @Override
    public Component getNotificationMessage(@NotNull Location location) {
        return null;
    }

    @Override
    public void sendNotificationMessage(@NotNull Location location) {
        if (this.notificationService != null) {
            this.notificationService.sendNotificationMessage(location);
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!this.regionService.isRegionOwner(location)) {
            return;
        }
        this.regionService.executeInRegion(location, () -> {
            LOGGER.debug("Sending sign notification at {}", (Object)location);
            String blockMaterialString = this.plugin.getConfig().getString("notification.sign.material", "OAK_SIGN");
            Material blockMaterial = Optional.ofNullable(Material.matchMaterial((String)blockMaterialString)).orElse(Material.OAK_SIGN);
            Block block = location.getWorld().getBlockAt(location);
            block.setType(blockMaterial, false);
            BlockState state = block.getState();
            LOGGER.debug("Block state is {}", (Object)state);
            if (state instanceof Sign) {
                int i;
                Sign sign = (Sign)state;
                sign.setMetadata("arcr-sign", (MetadataValue)this.metaValue);
                SignSide side = sign.getSide(Side.BACK);
                List<Component> lines = this.plugin.getConfig().getStringList("notification.sign.back").stream().map(arg_0 -> MiniMessage.miniMessage().deserialize(arg_0)).limit(4L).toList();
                for (i = 0; i < lines.size(); ++i) {
                    side.line(i, lines.get(i));
                }
                sign.update(true, false);
                lines = this.plugin.getConfig().getStringList("notification.sign.front").stream().map(arg_0 -> MiniMessage.miniMessage().deserialize(arg_0)).limit(4L).toList();
                side = sign.getSide(Side.FRONT);
                for (i = 0; i < lines.size(); ++i) {
                    side.line(i, lines.get(i));
                }
                sign.update(true, false);
            }
            LOGGER.debug("Updating sign at {}", (Object)location);
            block.getState().update();
        }, 2L);
    }

    @Override
    public boolean isEnabled() {
        return this.plugin.getConfig().getStringList("notification.enabled").contains("sign");
    }
}

