/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.mcdiscordreserializer.renderer;

import dev.vankka.mcdiscordreserializer.minecraft.MinecraftSerializerOptions;
import dev.vankka.mcdiscordreserializer.renderer.MinecraftNodeRenderer;
import dev.vankka.mcdiscordreserializer.rules.DiscordMarkdownRules;
import dev.vankka.mcdiscordreserializer.rules.StyleNode;
import dev.vankka.simpleast.core.node.Node;
import dev.vankka.simpleast.core.node.TextNode;
import dev.vankka.simpleast.core.parser.Parser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MinecraftRenderer
extends MinecraftNodeRenderer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    default public Component render(@NotNull Component component, @NotNull Node<Object> node, @NotNull MinecraftSerializerOptions<Component> serializerOptions, @NotNull Function<Node<Object>, Component> renderWithChildren) {
        if (node instanceof TextNode) {
            component = ((TextComponent)component).content(((TextNode)node).getContent());
        } else if (node instanceof StyleNode) {
            ArrayList styles = new ArrayList(((StyleNode)node).getStyles());
            for (StyleNode.Style style : styles) {
                if (style instanceof StyleNode.MentionStyle) {
                    StyleNode.MentionStyle mentionStyle = (StyleNode.MentionStyle)style;
                    String id = mentionStyle.getId();
                    switch (mentionStyle.getType()) {
                        case ROLE: {
                            component = this.appendRoleMention(component, id);
                            break;
                        }
                        case USER: {
                            component = this.appendUserMention(component, id);
                            break;
                        }
                        case CHANNEL: {
                            component = this.appendChannelMention(component, id);
                        }
                    }
                } else if (style instanceof StyleNode.EmojiStyle) {
                    StyleNode.EmojiStyle emojiStyle = (StyleNode.EmojiStyle)style;
                    component = this.appendEmoteMention(component, emojiStyle.getName(), emojiStyle.getId());
                } else if (style instanceof StyleNode.CodeBlockStyle) {
                    StyleNode.CodeBlockStyle codeBlockStyle = (StyleNode.CodeBlockStyle)style;
                    component = this.codeBlock(component, codeBlockStyle.getLanguage());
                    ((StyleNode)node).getStyles().remove(style);
                } else if (style instanceof StyleNode.ContentStyle) {
                    StyleNode.ContentStyle contentStyle = (StyleNode.ContentStyle)style;
                    switch (contentStyle.getType()) {
                        case LINK: {
                            component = this.appendLink(component, contentStyle.getContent());
                            break;
                        }
                        case QUOTE: {
                            List<Node<Object>> nodes;
                            TextComponent content = Component.empty();
                            Parser<Object, Node<Object>, Object> parser = serializerOptions.getParser();
                            Iterator<Node<Object>> iterator2 = parser;
                            synchronized (iterator2) {
                                nodes = parser.parse(contentStyle.getContent(), new DiscordMarkdownRules.QuoteState(true), serializerOptions.getRules(), serializerOptions.isDebuggingEnabled());
                            }
                            for (Node<Object> objectNode : nodes) {
                                content = (TextComponent)content.append(renderWithChildren.apply(objectNode));
                            }
                            component = this.appendQuote(component, content);
                            break;
                        }
                        case SPOILER: {
                            List<Node<Object>> nodes;
                            TextComponent content = Component.empty();
                            Parser<Object, Node<Object>, Object> parser = serializerOptions.getParser();
                            Iterator<Node<Object>> iterator2 = parser;
                            synchronized (iterator2) {
                                nodes = parser.parse(contentStyle.getContent(), null, serializerOptions.getRules(), serializerOptions.isDebuggingEnabled());
                            }
                            for (Node<Object> objectNode : nodes) {
                                content = (TextComponent)content.append(renderWithChildren.apply(objectNode));
                            }
                            component = this.appendSpoiler(component, content);
                            break;
                        }
                    }
                } else if (style instanceof StyleNode.ItalicStyle) {
                    component = this.italics(component);
                } else if (style instanceof StyleNode.Styles) {
                    switch ((StyleNode.Styles)style) {
                        case CODE_STRING: {
                            component = this.codeString(component);
                            ((StyleNode)node).getStyles().remove(style);
                            break;
                        }
                        case BOLD: {
                            component = this.bold(component);
                            break;
                        }
                        case UNDERLINE: {
                            component = this.underline(component);
                            break;
                        }
                        case STRIKETHROUGH: {
                            component = this.strikethrough(component);
                        }
                    }
                }
                if (component != null) continue;
                break;
            }
        }
        return component;
    }

    @Deprecated
    public Component link(@NotNull Component var1, String var2);

    default public Component appendLink(@NotNull Component component, String link) {
        Component linkComponent = Component.empty();
        if ((linkComponent = this.link(linkComponent, link)) == null) {
            return null;
        }
        return component.append(linkComponent.append(Component.text(link)));
    }

    @Nullable
    public Component strikethrough(@NotNull Component var1);

    @Nullable
    public Component underline(@NotNull Component var1);

    @Nullable
    public Component italics(@NotNull Component var1);

    @Nullable
    public Component bold(@NotNull Component var1);

    @Nullable
    public Component codeString(@NotNull Component var1);

    @Nullable
    default public Component codeBlock(@NotNull Component part, @Nullable String language) {
        return this.codeBlock(part);
    }

    @Nullable
    public Component codeBlock(@NotNull Component var1);

    @Nullable
    public Component appendSpoiler(@NotNull Component var1, @NotNull Component var2);

    @Nullable
    public Component appendQuote(@NotNull Component var1, @NotNull Component var2);

    @Nullable
    public Component appendEmoteMention(@NotNull Component var1, @NotNull String var2, @NotNull String var3);

    @Nullable
    public Component appendChannelMention(@NotNull Component var1, @NotNull String var2);

    @Nullable
    public Component appendUserMention(@NotNull Component var1, @NotNull String var2);

    @Nullable
    public Component appendRoleMention(@NotNull Component var1, @NotNull String var2);
}

