/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.mcdiscordreserializer.minecraft;

import dev.vankka.mcdiscordreserializer.renderer.NodeRenderer;
import dev.vankka.mcdiscordreserializer.renderer.implementation.DefaultMinecraftRenderer;
import dev.vankka.mcdiscordreserializer.rules.DiscordMarkdownRules;
import dev.vankka.simpleast.core.node.Node;
import dev.vankka.simpleast.core.parser.Parser;
import dev.vankka.simpleast.core.parser.Rule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinecraftSerializerOptions<O> {
    @NotNull
    private final Parser<Object, Node<Object>, Object> parser;
    @Nullable
    private final List<Rule<Object, Node<Object>, Object>> rules;
    @NotNull
    private final List<NodeRenderer<O>> renderers;
    private final boolean debuggingEnabled;

    public static MinecraftSerializerOptions<Component> defaults() {
        return new MinecraftSerializerOptions<Component>(new Parser<Object, Node<Object>, Object>(), DiscordMarkdownRules.createAllRulesForDiscord(true), Collections.emptyList(), false);
    }

    public MinecraftSerializerOptions(@NotNull Parser<Object, Node<Object>, Object> parser, @Nullable List<Rule<Object, Node<Object>, Object>> rules, @NotNull List<NodeRenderer<O>> renderers, boolean debuggingEnabled) {
        this.parser = parser;
        this.rules = rules != null ? Collections.unmodifiableList(rules) : null;
        this.renderers = Collections.unmodifiableList(renderers);
        this.debuggingEnabled = debuggingEnabled;
    }

    @NotNull
    public Parser<Object, Node<Object>, Object> getParser() {
        return this.parser;
    }

    public MinecraftSerializerOptions<O> withParser(@NotNull Parser<Object, Node<Object>, Object> parser) {
        return new MinecraftSerializerOptions<O>(parser, this.rules, this.renderers, this.debuggingEnabled);
    }

    @Nullable
    public List<Rule<Object, Node<Object>, Object>> getRules() {
        return this.rules;
    }

    public MinecraftSerializerOptions<O> withRules(@NotNull List<Rule<Object, Node<Object>, Object>> rules) {
        return new MinecraftSerializerOptions<O>(this.parser, rules, this.renderers, this.debuggingEnabled);
    }

    @NotNull
    public MinecraftSerializerOptions<O> addRenderer(@NotNull NodeRenderer<O> renderer) {
        if (this.renderers.contains(renderer)) {
            throw new IllegalArgumentException("The provided renderer is already included in this options instance");
        }
        if (renderer.getClass().equals(DefaultMinecraftRenderer.class)) {
            throw new IllegalArgumentException("DefaultMinecraftRenderer cannot be added to serializer options");
        }
        ArrayList<NodeRenderer<O>> renderers = new ArrayList<NodeRenderer<O>>(this.renderers);
        renderers.add(renderer);
        return new MinecraftSerializerOptions<O>(this.parser, this.rules, renderers, this.debuggingEnabled);
    }

    @NotNull
    public MinecraftSerializerOptions<O> addRenderer(int index, @NotNull NodeRenderer<O> renderer) {
        if (this.renderers.contains(renderer)) {
            throw new IllegalArgumentException("The provided renderer is already included in this options instance");
        }
        if (renderer.getClass().equals(DefaultMinecraftRenderer.class)) {
            throw new IllegalArgumentException("DefaultMinecraftRenderer cannot be added to serializer options");
        }
        ArrayList<NodeRenderer<O>> renderers = new ArrayList<NodeRenderer<O>>(this.renderers);
        renderers.add(index, renderer);
        return new MinecraftSerializerOptions<O>(this.parser, this.rules, renderers, this.debuggingEnabled);
    }

    public MinecraftSerializerOptions<O> removeRenderer(NodeRenderer<O> renderer) {
        if (!this.renderers.contains(renderer)) {
            throw new IllegalArgumentException("The provided renderer is not included in this options instance");
        }
        ArrayList<NodeRenderer<O>> renderers = new ArrayList<NodeRenderer<O>>(this.renderers);
        renderers.remove(renderer);
        return new MinecraftSerializerOptions<O>(this.parser, this.rules, renderers, this.debuggingEnabled);
    }

    @NotNull
    public List<NodeRenderer<O>> getRenderers() {
        return this.renderers;
    }

    public boolean isDebuggingEnabled() {
        return this.debuggingEnabled;
    }

    public MinecraftSerializerOptions<O> withDebuggingEnabled(boolean debuggingEnabled) {
        return new MinecraftSerializerOptions<O>(this.parser, this.rules, this.renderers, debuggingEnabled);
    }

    public String toString() {
        return "MinecraftSerializerOptions{parser=" + this.parser + ", rules=" + this.rules + ", renderers=" + this.renderers + ", debuggingEnabled=" + this.debuggingEnabled + '}';
    }
}

