/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.mcdiscordreserializer.minecraft;

import dev.vankka.mcdiscordreserializer.minecraft.MinecraftSerializerOptions;
import dev.vankka.mcdiscordreserializer.renderer.NodeRenderer;
import dev.vankka.mcdiscordreserializer.renderer.implementation.DefaultMinecraftRenderer;
import dev.vankka.simpleast.core.node.Node;
import dev.vankka.simpleast.core.node.TextNode;
import dev.vankka.simpleast.core.parser.Parser;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

public class MinecraftSerializer {
    @NotNull
    public static final MinecraftSerializer INSTANCE = new MinecraftSerializer(){

        @Override
        public void setDefaultOptions(@NotNull MinecraftSerializerOptions<Component> defaultOptions) {
            throw new UnsupportedOperationException("Cannot modify public instance");
        }
    };
    @NotNull
    private MinecraftSerializerOptions<Component> defaultOptions;

    public MinecraftSerializer() {
        this(MinecraftSerializerOptions.defaults());
    }

    public MinecraftSerializer(@NotNull MinecraftSerializerOptions<Component> defaultOptions) {
        this.defaultOptions = defaultOptions;
    }

    @NotNull
    public MinecraftSerializerOptions<Component> getDefaultOptions() {
        return this.defaultOptions;
    }

    public void setDefaultOptions(@NotNull MinecraftSerializerOptions<Component> defaultOptions) {
        this.defaultOptions = defaultOptions;
    }

    @NotNull
    public Component serialize(@NotNull String discordMessage) {
        MinecraftSerializerOptions<Component> options = this.getDefaultOptions();
        return this.serialize(discordMessage, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Component serialize(@NotNull String discordMessage, @NotNull MinecraftSerializerOptions<Component> serializerOptions) {
        List<Node<Object>> nodes;
        ArrayList<Component> components = new ArrayList<Component>();
        Parser<Object, Node<Object>, Object> parser = serializerOptions.getParser();
        Parser<Object, Node<Object>, Object> parser2 = parser;
        synchronized (parser2) {
            nodes = parser.parse(discordMessage, null, serializerOptions.getRules(), serializerOptions.isDebuggingEnabled());
        }
        nodes = this.flattenTextNodes(nodes);
        for (Node node : nodes) {
            components.add(this.addChild(node, serializerOptions, null));
        }
        if (components.size() == 1) {
            return (Component)components.get(0);
        }
        return Component.empty().children(components);
    }

    private Component addChild(Node<Object> node, MinecraftSerializerOptions<Component> serializerOptions, Component component) {
        Component newOutput;
        if (component == null) {
            component = Component.empty();
        }
        Function<Node, Component> renderWithChildren = otherNode -> this.addChild((Node<Object>)otherNode, serializerOptions, null);
        Component output = null;
        NodeRenderer<Component> render = null;
        for (NodeRenderer<Component> renderer : serializerOptions.getRenderers()) {
            Component currentOutput = renderer.render(component, node, serializerOptions, renderWithChildren);
            if (currentOutput == null) continue;
            output = currentOutput;
            render = renderer;
            break;
        }
        if (output == null && (output = (render = DefaultMinecraftRenderer.INSTANCE).render(component, node, serializerOptions, renderWithChildren)) == null) {
            throw new IllegalStateException("DefaultMinecraftRenderer returned a null component");
        }
        List<Node<Object>> children = node.getChildren();
        if (children != null) {
            boolean first = true;
            for (Node node2 : children) {
                if (first && node2 instanceof TextNode) {
                    output = this.addChild(node2, serializerOptions, output);
                    first = false;
                    continue;
                }
                first = false;
                output = output.append(this.addChild(node2, serializerOptions, null));
            }
        }
        if ((newOutput = render.renderAfterChildren(output, node, serializerOptions, renderWithChildren)) != null) {
            output = newOutput;
        }
        return output;
    }

    private <R, T extends Node<R>> List<T> flattenTextNodes(List<T> nodes) {
        ArrayList<Node> newNodes = new ArrayList<Node>();
        TextNode previousNode = null;
        for (Node node : nodes) {
            List children = node.getChildren();
            if (!children.isEmpty()) {
                if (previousNode != null) {
                    newNodes.add(previousNode);
                    previousNode = null;
                }
                List childNodes = this.flattenTextNodes(children);
                node.getChildren().clear();
                node.getChildren().addAll(childNodes);
                newNodes.add(node);
                continue;
            }
            if (!(node instanceof TextNode)) {
                if (previousNode != null) {
                    newNodes.add(previousNode);
                    previousNode = null;
                }
                newNodes.add(node);
                continue;
            }
            if (previousNode == null) {
                previousNode = (TextNode)node;
                continue;
            }
            previousNode = new TextNode(previousNode.getContent() + ((TextNode)node).getContent());
        }
        if (previousNode != null) {
            newNodes.add(previousNode);
        }
        return newNodes;
    }
}

