/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.mcdiscordreserializer.discord;

import dev.vankka.mcdiscordreserializer.discord.DiscordSerializerOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.flattener.FlattenerListener;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.ComponentEncoder;
import org.jetbrains.annotations.NotNull;

public class DiscordSerializer
implements ComponentEncoder<Component, String> {
    private static final Pattern LINK_PATTERN = Pattern.compile("(https?://.*\\.[^ ]*)$");
    public static final DiscordSerializer INSTANCE = new DiscordSerializer(){

        @Override
        public void setDefaultOptions(@NotNull DiscordSerializerOptions defaultOptions) {
            throw new UnsupportedOperationException("Cannot modify public instance");
        }
    };
    @NotNull
    private DiscordSerializerOptions defaultOptions;

    public DiscordSerializer() {
        this(DiscordSerializerOptions.defaults());
    }

    public DiscordSerializer(@NotNull DiscordSerializerOptions defaultOptions) {
        this.defaultOptions = defaultOptions;
    }

    @NotNull
    public DiscordSerializerOptions getDefaultOptions() {
        return this.defaultOptions;
    }

    public void setDefaultOptions(@NotNull DiscordSerializerOptions defaultOptions) {
        this.defaultOptions = defaultOptions;
    }

    @Override
    @NotNull
    public String serialize(@NotNull Component component) {
        DiscordSerializerOptions options = this.getDefaultOptions();
        return this.serialize(component, options);
    }

    @NotNull
    public String serialize(@NotNull Component component, @NotNull DiscordSerializerOptions serializerOptions) {
        ComponentFlattener flattener = serializerOptions.getFlattener();
        FlattenListener listener = new FlattenListener(serializerOptions);
        flattener.flatten(component, listener);
        StringBuilder stringBuilder = new StringBuilder();
        List<Text> texts = listener.getTexts();
        for (Text text : texts) {
            String content = text.getContent().toString();
            if (content.isEmpty()) continue;
            if (text.isBold()) {
                stringBuilder.append("**");
            }
            if (text.isStrikethrough()) {
                stringBuilder.append("~~");
            }
            if (text.isItalic()) {
                stringBuilder.append("_");
            }
            if (text.isUnderline()) {
                stringBuilder.append("__");
            }
            if (serializerOptions.isEscapeMarkdown() && !LINK_PATTERN.matcher(stringBuilder).find()) {
                content = content.replace("*", "\\*").replace("~", "\\~").replace("_", "\\_").replace("`", "\\`").replace("|", "\\|").replace(":", "\\:").replace("[", "\\[");
            }
            String openUrl = text.getOpenUrl();
            if (serializerOptions.isMaskedLinks() && openUrl != null) {
                String display = text.getUrlHover();
                content = "[" + content + "](<" + openUrl + ">" + (display != null ? " \"" + display + "\"" : "") + ")";
            }
            stringBuilder.append(content);
            if (text.isUnderline()) {
                stringBuilder.append("__");
            }
            if (text.isItalic()) {
                stringBuilder.append("_");
            }
            if (text.isStrikethrough()) {
                stringBuilder.append("~~");
            }
            if (text.isBold()) {
                stringBuilder.append("**");
            }
            stringBuilder.append("\u200b");
        }
        int length = stringBuilder.length();
        return length < 1 ? "" : stringBuilder.substring(0, length - 1);
    }

    private static class Text {
        private final StringBuilder content = new StringBuilder();
        private boolean bold;
        private boolean strikethrough;
        private boolean underline;
        private boolean italic;
        private String openUrl;
        private String urlHover;

        public Text() {
        }

        private Text(StringBuilder content, boolean bold, boolean strikethrough, boolean underline, boolean italic, String openUrl, String urlHover) {
            this.content.append((CharSequence)content);
            this.bold = bold;
            this.strikethrough = strikethrough;
            this.underline = underline;
            this.italic = italic;
            this.openUrl = openUrl;
            this.urlHover = urlHover;
        }

        public StringBuilder getContent() {
            return this.content;
        }

        public void appendContent(String content) {
            this.content.append(content);
        }

        public boolean isBold() {
            return this.bold;
        }

        public void setBold(boolean bold) {
            this.bold = bold;
        }

        public boolean isStrikethrough() {
            return this.strikethrough;
        }

        public void setStrikethrough(boolean strikethrough) {
            this.strikethrough = strikethrough;
        }

        public boolean isUnderline() {
            return this.underline;
        }

        public void setUnderline(boolean underline) {
            this.underline = underline;
        }

        public boolean isItalic() {
            return this.italic;
        }

        public void setItalic(boolean italic) {
            this.italic = italic;
        }

        public String getOpenUrl() {
            return this.openUrl;
        }

        public void setOpenUrl(String openUrl) {
            this.openUrl = openUrl;
        }

        public String getUrlHover() {
            return this.urlHover;
        }

        public void setUrlHover(String urlHover) {
            this.urlHover = urlHover;
        }

        public boolean formattingMatches(Text other) {
            return other != null && this.bold == other.bold && this.strikethrough == other.strikethrough && this.underline == other.underline && this.italic == other.italic && Objects.equals(this.openUrl, other.openUrl) && Objects.equals(this.urlHover, other.urlHover);
        }

        public Text clone() {
            return new Text(this.content, this.bold, this.strikethrough, this.underline, this.italic, this.openUrl, this.urlHover);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Text text = (Text)o;
            return this.bold == text.bold && this.strikethrough == text.strikethrough && this.underline == text.underline && this.italic == text.italic && this.content.toString().contentEquals(text.content) && Objects.equals(this.openUrl, text.openUrl) && Objects.equals(this.urlHover, text.urlHover);
        }

        public int hashCode() {
            return Objects.hash(this.content, this.bold, this.strikethrough, this.underline, this.italic, this.openUrl, this.urlHover);
        }
    }

    private static class FlattenToTextOnly
    implements FlattenerListener {
        private final StringBuilder builder = new StringBuilder();

        private FlattenToTextOnly() {
        }

        @Override
        public void component(@NotNull String text) {
            this.builder.append(text);
        }

        public String getContent() {
            return this.builder.toString();
        }
    }

    private static class FlattenListener
    implements FlattenerListener {
        private final Map<Style, Text> previousText = new HashMap<Style, Text>();
        private final List<Text> texts = new ArrayList<Text>();
        private Text currentText = null;
        private final DiscordSerializerOptions serializerOptions;
        private final boolean gatherLinks;

        public FlattenListener(DiscordSerializerOptions serializerOptions) {
            this.serializerOptions = serializerOptions;
            this.gatherLinks = serializerOptions.isMaskedLinks();
        }

        public List<Text> getTexts() {
            if (this.currentText != null) {
                this.texts.add(this.currentText);
            }
            return this.texts;
        }

        @Override
        public void pushStyle(@NotNull Style style) {
            TextDecoration.State strikethrough;
            TextDecoration.State underline;
            TextDecoration.State italic;
            Text text;
            Object isBold = null;
            Object isItalic = null;
            Object isUnderline = null;
            Object isStrikethrough = null;
            if (this.currentText != null) {
                text = this.currentText.clone();
                text.getContent().setLength(0);
            } else {
                text = new Text();
            }
            TextDecoration.State bold = style.decoration(TextDecoration.BOLD);
            if (bold != TextDecoration.State.NOT_SET) {
                boolean wasBold = text.isBold();
                text.setBold(bold == TextDecoration.State.TRUE);
            }
            if ((italic = style.decoration(TextDecoration.ITALIC)) != TextDecoration.State.NOT_SET) {
                boolean wasItalic = text.isItalic();
                text.setItalic(italic == TextDecoration.State.TRUE);
            }
            if ((underline = style.decoration(TextDecoration.UNDERLINED)) != TextDecoration.State.NOT_SET) {
                boolean wasUnderline = text.isUnderline();
                text.setUnderline(underline == TextDecoration.State.TRUE);
            }
            if ((strikethrough = style.decoration(TextDecoration.STRIKETHROUGH)) != TextDecoration.State.NOT_SET) {
                boolean wasStrikethrough = text.isStrikethrough();
                text.setStrikethrough(strikethrough == TextDecoration.State.TRUE);
            }
            ClickEvent clickEvent = style.clickEvent();
            if (this.gatherLinks && clickEvent != null && clickEvent.action() == ClickEvent.Action.OPEN_URL) {
                text.setOpenUrl(clickEvent.value());
            }
            HoverEvent<?> hoverEvent = style.hoverEvent();
            if (this.gatherLinks && hoverEvent != null && hoverEvent.action() == HoverEvent.Action.SHOW_TEXT) {
                FlattenToTextOnly flatten2 = new FlattenToTextOnly();
                this.serializerOptions.getFlattener().flatten((Component)hoverEvent.value(), flatten2);
                text.setUrlHover(flatten2.getContent());
            }
            if (this.currentText == null) {
                this.currentText = text;
            } else if (!text.formattingMatches(this.currentText)) {
                this.texts.add(this.currentText);
                this.previousText.put(style, this.currentText.clone());
                this.currentText = text;
            }
        }

        @Override
        public void popStyle(@NotNull Style style) {
            Text pop = this.previousText.remove(style);
            if (pop != null) {
                this.texts.add(this.currentText);
                this.currentText = pop;
                this.currentText.getContent().setLength(0);
            }
        }

        @Override
        public void component(@NotNull String text) {
            if (this.currentText == null) {
                this.currentText = new Text();
            }
            this.currentText.appendContent(text);
        }
    }
}

