/*
 * Decompiled with CFR 0.152.
 */
package net.onelitefeather.antiredstoneclockremastered.service.chain;

import jakarta.inject.Inject;
import net.onelitefeather.antiredstoneclockremastered.AntiRedstoneClockRemastered;
import net.onelitefeather.antiredstoneclockremastered.service.api.RedstoneClockMiddleware;
import net.onelitefeather.antiredstoneclockremastered.service.api.RedstoneTrackingService;
import org.jetbrains.annotations.NotNull;

public final class TrackingRedstoneClockMiddleware
extends RedstoneClockMiddleware {
    private final RedstoneTrackingService trackingService;
    private final AntiRedstoneClockRemastered antiRedstoneClockRemastered;

    @Inject
    public TrackingRedstoneClockMiddleware(RedstoneTrackingService trackingService, AntiRedstoneClockRemastered antiRedstoneClockRemastered) {
        this.trackingService = trackingService;
        this.antiRedstoneClockRemastered = antiRedstoneClockRemastered;
    }

    @Override
    @NotNull
    public RedstoneClockMiddleware.ResultState check(@NotNull RedstoneClockMiddleware.CheckContext context) {
        if (this.trackingService.isRedstoneClock(context)) {
            boolean autoBreak = this.antiRedstoneClockRemastered.getConfig().getBoolean("clock.autoBreak", true);
            if (!autoBreak) {
                return RedstoneClockMiddleware.ResultState.ONLY_NOTIFY;
            }
            boolean autoDrop = this.antiRedstoneClockRemastered.getConfig().getBoolean("clock.drop", false);
            if (autoDrop) {
                return RedstoneClockMiddleware.ResultState.REMOVE_AND_DROP;
            }
            return RedstoneClockMiddleware.ResultState.REMOVE_AND_WITHOUT_DROP;
        }
        return RedstoneClockMiddleware.ResultState.SKIP;
    }
}

