/*
 * Decompiled with CFR 0.152.
 */
package net.onelitefeather.antiredstoneclockremastered.com.jeff_media.customblockdata;

import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.onelitefeather.antiredstoneclockremastered.com.jeff_media.customblockdata.BlockDataListener;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.Listener;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.BlockVector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomBlockData
implements PersistentDataContainer {
    private static final char[] DEFAULT_PACKAGE = new char[]{'c', 'o', 'm', '.', 'j', 'e', 'f', 'f', '_', 'm', 'e', 'd', 'i', 'a', '.', 'c', 'u', 's', 't', 'o', 'm', 'b', 'l', 'o', 'c', 'k', 'd', 'a', 't', 'a'};
    private static final Set<Map.Entry<UUID, BlockVector>> DIRTY_BLOCKS = new HashSet<Map.Entry<UUID, BlockVector>>();
    private static final PersistentDataType<?, ?>[] PRIMITIVE_DATA_TYPES = new PersistentDataType[]{PersistentDataType.BYTE, PersistentDataType.SHORT, PersistentDataType.INTEGER, PersistentDataType.LONG, PersistentDataType.FLOAT, PersistentDataType.DOUBLE, PersistentDataType.STRING, PersistentDataType.BYTE_ARRAY, PersistentDataType.INTEGER_ARRAY, PersistentDataType.LONG_ARRAY, PersistentDataType.TAG_CONTAINER_ARRAY, PersistentDataType.TAG_CONTAINER};
    private static final NamespacedKey PERSISTENCE_KEY = Objects.requireNonNull(NamespacedKey.fromString((String)"customblockdata:protected"), "Could not create persistence NamespacedKey");
    private static final Pattern KEY_REGEX = Pattern.compile("^x(\\d+)y(-?\\d+)z(\\d+)$");
    private static final int CHUNK_MIN_XZ = 0;
    private static final int CHUNK_MAX_XZ = 15;
    private static final boolean HAS_MIN_HEIGHT_METHOD;
    private static boolean onFolia;
    private final PersistentDataContainer pdc;
    private final Chunk chunk;
    private final NamespacedKey key;
    private final Map.Entry<UUID, BlockVector> blockEntry;
    private final Plugin plugin;

    public CustomBlockData(@NotNull Block block, @NotNull Plugin plugin) {
        this.chunk = block.getChunk();
        this.key = CustomBlockData.getKey(plugin, block);
        this.pdc = this.getPersistentDataContainer();
        this.blockEntry = CustomBlockData.getBlockEntry(block);
        this.plugin = plugin;
    }

    @Deprecated
    public CustomBlockData(@NotNull Block block, @NotNull String namespace) {
        this.chunk = block.getChunk();
        this.key = new NamespacedKey(namespace, CustomBlockData.getKey(block));
        this.pdc = this.getPersistentDataContainer();
        this.plugin = JavaPlugin.getProvidingPlugin(CustomBlockData.class);
        this.blockEntry = CustomBlockData.getBlockEntry(block);
    }

    private static void checkRelocation() {
        if (CustomBlockData.class.getPackage().getName().equals(new String(DEFAULT_PACKAGE))) {
            try {
                JavaPlugin plugin = JavaPlugin.getProvidingPlugin(CustomBlockData.class);
                plugin.getLogger().warning("Nag author(s) " + String.join((CharSequence)", ", plugin.getDescription().getAuthors()) + " of plugin " + plugin.getName() + " for not relocating the CustomBlockData package.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private static Map.Entry<UUID, BlockVector> getBlockEntry(@NotNull Block block) {
        UUID uuid = block.getWorld().getUID();
        BlockVector blockVector = new BlockVector(block.getX(), block.getY(), block.getZ());
        return new AbstractMap.SimpleEntry<UUID, BlockVector>(uuid, blockVector);
    }

    static boolean isDirty(Block block) {
        return DIRTY_BLOCKS.contains(CustomBlockData.getBlockEntry(block));
    }

    static void setDirty(Plugin plugin, Map.Entry<UUID, BlockVector> blockEntry) {
        if (!plugin.isEnabled()) {
            return;
        }
        DIRTY_BLOCKS.add(blockEntry);
        if (onFolia) {
            Bukkit.getServer().getGlobalRegionScheduler().runDelayed(plugin, task -> DIRTY_BLOCKS.remove(blockEntry), 1L);
        } else {
            Bukkit.getScheduler().runTask(plugin, () -> DIRTY_BLOCKS.remove(blockEntry));
        }
    }

    private static NamespacedKey getKey(Plugin plugin, Block block) {
        return new NamespacedKey(plugin, CustomBlockData.getKey(block));
    }

    @NotNull
    static String getKey(@NotNull Block block) {
        int x = block.getX() & 0xF;
        int y = block.getY();
        int z = block.getZ() & 0xF;
        return "x" + x + "y" + y + "z" + z;
    }

    @Nullable
    static Block getBlockFromKey(NamespacedKey key, Chunk chunk) {
        Matcher matcher = KEY_REGEX.matcher(key.getKey());
        if (!matcher.matches()) {
            return null;
        }
        int x = Integer.parseInt(matcher.group(1));
        int y = Integer.parseInt(matcher.group(2));
        int z = Integer.parseInt(matcher.group(3));
        if (x < 0 || x > 15 || z < 0 || z > 15 || y < CustomBlockData.getWorldMinHeight(chunk.getWorld()) || y > chunk.getWorld().getMaxHeight() - 1) {
            return null;
        }
        return chunk.getBlock(x, y, z);
    }

    static int getWorldMinHeight(World world) {
        if (HAS_MIN_HEIGHT_METHOD) {
            return world.getMinHeight();
        }
        return 0;
    }

    public static boolean hasCustomBlockData(Block block, Plugin plugin) {
        return block.getChunk().getPersistentDataContainer().has(CustomBlockData.getKey(plugin, block), PersistentDataType.TAG_CONTAINER);
    }

    public static boolean isProtected(Block block, Plugin plugin) {
        return new CustomBlockData(block, plugin).isProtected();
    }

    public static void registerListener(Plugin plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)new BlockDataListener(plugin), plugin);
    }

    @NotNull
    public static Set<Block> getBlocksWithCustomData(Plugin plugin, Chunk chunk) {
        NamespacedKey dummy = new NamespacedKey(plugin, "dummy");
        return CustomBlockData.getBlocksWithCustomData(chunk, dummy);
    }

    @NotNull
    private static Set<Block> getBlocksWithCustomData(@NotNull Chunk chunk, @NotNull NamespacedKey namespace) {
        PersistentDataContainer chunkPDC = chunk.getPersistentDataContainer();
        return chunkPDC.getKeys().stream().filter(key -> key.getNamespace().equals(namespace.getNamespace())).map(key -> CustomBlockData.getBlockFromKey(key, chunk)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @NotNull
    public static Set<Block> getBlocksWithCustomData(String namespace, Chunk chunk) {
        NamespacedKey dummy = new NamespacedKey(namespace, "dummy");
        return CustomBlockData.getBlocksWithCustomData(chunk, dummy);
    }

    public static PersistentDataType<?, ?> getDataType(PersistentDataContainer pdc, NamespacedKey key) {
        for (PersistentDataType<?, ?> dataType : PRIMITIVE_DATA_TYPES) {
            if (!pdc.has(key, dataType)) continue;
            return dataType;
        }
        return null;
    }

    @Nullable
    public Block getBlock() {
        World world = Bukkit.getWorld((UUID)this.blockEntry.getKey());
        if (world == null) {
            return null;
        }
        BlockVector vector = this.blockEntry.getValue();
        return world.getBlockAt(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }

    @NotNull
    private PersistentDataContainer getPersistentDataContainer() {
        PersistentDataContainer chunkPDC = this.chunk.getPersistentDataContainer();
        PersistentDataContainer blockPDC = (PersistentDataContainer)chunkPDC.get(this.key, PersistentDataType.TAG_CONTAINER);
        if (blockPDC != null) {
            return blockPDC;
        }
        return chunkPDC.getAdapterContext().newPersistentDataContainer();
    }

    public boolean isProtected() {
        return this.has(PERSISTENCE_KEY, DataType.BOOLEAN);
    }

    public void setProtected(boolean isProtected) {
        if (isProtected) {
            this.set(PERSISTENCE_KEY, DataType.BOOLEAN, true);
        } else {
            this.remove(PERSISTENCE_KEY);
        }
    }

    public void clear() {
        this.pdc.getKeys().forEach(arg_0 -> ((PersistentDataContainer)this.pdc).remove(arg_0));
        this.save();
    }

    private void save() {
        CustomBlockData.setDirty(this.plugin, this.blockEntry);
        if (this.pdc.isEmpty()) {
            this.chunk.getPersistentDataContainer().remove(this.key);
        } else {
            this.chunk.getPersistentDataContainer().set(this.key, PersistentDataType.TAG_CONTAINER, (Object)this.pdc);
        }
    }

    public void copyTo(Block block, Plugin plugin) {
        CustomBlockData newCbd = new CustomBlockData(block, plugin);
        this.getKeys().forEach(key -> {
            PersistentDataType<?, ?> dataType = CustomBlockData.getDataType(this, key);
            if (dataType == null) {
                return;
            }
            newCbd.set((NamespacedKey)key, (PersistentDataType)dataType, (Object)this.get((NamespacedKey)key, (PersistentDataType)dataType));
        });
    }

    public <T, Z> void set(@NotNull NamespacedKey namespacedKey, @NotNull PersistentDataType<T, Z> persistentDataType, @NotNull Z z) {
        this.pdc.set(namespacedKey, persistentDataType, z);
        this.save();
    }

    public <T, Z> boolean has(@NotNull NamespacedKey namespacedKey, @NotNull PersistentDataType<T, Z> persistentDataType) {
        return this.pdc.has(namespacedKey, persistentDataType);
    }

    public boolean has(@NotNull NamespacedKey namespacedKey) {
        for (PersistentDataType<?, ?> type : PRIMITIVE_DATA_TYPES) {
            if (!this.pdc.has(namespacedKey, type)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public <T, Z> Z get(@NotNull NamespacedKey namespacedKey, @NotNull PersistentDataType<T, Z> persistentDataType) {
        return (Z)this.pdc.get(namespacedKey, persistentDataType);
    }

    @NotNull
    public <T, Z> Z getOrDefault(@NotNull NamespacedKey namespacedKey, @NotNull PersistentDataType<T, Z> persistentDataType, @NotNull Z z) {
        return (Z)this.pdc.getOrDefault(namespacedKey, persistentDataType, z);
    }

    @NotNull
    public Set<NamespacedKey> getKeys() {
        return this.pdc.getKeys();
    }

    public void remove(@NotNull NamespacedKey namespacedKey) {
        this.pdc.remove(namespacedKey);
        this.save();
    }

    public boolean isEmpty() {
        return this.pdc.isEmpty();
    }

    @NotNull
    public PersistentDataAdapterContext getAdapterContext() {
        return this.pdc.getAdapterContext();
    }

    @Deprecated
    @NotNull
    @PaperOnly
    public byte[] serializeToBytes() throws IOException {
        return this.pdc.serializeToBytes();
    }

    @Deprecated
    @PaperOnly
    public void readFromBytes(byte[] bytes, boolean clear) throws IOException {
        this.pdc.readFromBytes(bytes, clear);
    }

    @Deprecated
    @PaperOnly
    public void readFromBytes(byte[] bytes) throws IOException {
        this.pdc.readFromBytes(bytes);
    }

    public PersistentDataType<?, ?> getDataType(NamespacedKey key) {
        return CustomBlockData.getDataType(this, key);
    }

    static {
        CustomBlockData.checkRelocation();
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            onFolia = true;
        }
        catch (ClassNotFoundException e) {
            onFolia = false;
        }
        boolean tmpHasMinHeightMethod = false;
        try {
            World.class.getMethod("getMinHeight", new Class[0]);
            tmpHasMinHeightMethod = true;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        HAS_MIN_HEIGHT_METHOD = tmpHasMinHeightMethod;
    }

    private static final class DataType {
        private static final PersistentDataType<Byte, Boolean> BOOLEAN = new PersistentDataType<Byte, Boolean>(){

            @NotNull
            public Class<Byte> getPrimitiveType() {
                return Byte.class;
            }

            @NotNull
            public Class<Boolean> getComplexType() {
                return Boolean.class;
            }

            @NotNull
            public Byte toPrimitive(@NotNull Boolean complex, @NotNull PersistentDataAdapterContext context) {
                return complex != false ? (byte)1 : 0;
            }

            @NotNull
            public Boolean fromPrimitive(@NotNull Byte primitive, @NotNull PersistentDataAdapterContext context) {
                return primitive == 1;
            }
        };

        private DataType() {
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.METHOD})
    private static @interface PaperOnly {
    }
}

