/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.mcdiscordreserializer.renderer.implementation;

import dev.vankka.mcdiscordreserializer.minecraft.MinecraftSerializerOptions;
import dev.vankka.mcdiscordreserializer.renderer.NodeRenderer;
import dev.vankka.simpleast.core.TextStyle;
import dev.vankka.simpleast.core.node.Node;
import dev.vankka.simpleast.core.node.StyleNode;
import dev.vankka.simpleast.core.node.TextNode;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultDiscordEscapingRenderer
implements NodeRenderer<String> {
    public static final DefaultDiscordEscapingRenderer INSTANCE = new DefaultDiscordEscapingRenderer();

    private String render(String renderTo, Node<Object> node, boolean after) {
        if (node instanceof TextNode && !after) {
            return renderTo + ((TextNode)node).getContent();
        }
        if (node instanceof StyleNode) {
            StringBuilder output = new StringBuilder(renderTo);
            for (Object style : ((StyleNode)node).getStyles()) {
                TextStyle textStyle = (TextStyle)style;
                TextStyle.Type styleType = textStyle.getType();
                if (styleType == TextStyle.Type.QUOTE && after) continue;
                output.append(this.getChar(textStyle));
            }
            return output.toString();
        }
        return null;
    }

    private String getChar(TextStyle textStyle) {
        switch (textStyle.getType()) {
            case BOLD: {
                return "\\*\\*";
            }
            case QUOTE: {
                return "\\>";
            }
            case ITALICS: {
                return "\\" + (textStyle.getExtra().getOrDefault("asterisk", "true").equals("true") ? "*" : "_");
            }
            case SPOILER: {
                return "\\|\\|";
            }
            case UNDERLINE: {
                return "\\_\\_";
            }
            case CODE_BLOCK: {
                return "\\`\\`\\`";
            }
            case CODE_STRING: {
                return "\\`";
            }
        }
        return null;
    }

    @Override
    public String render(@Nullable String renderTo, @NotNull Node<Object> node, @NotNull MinecraftSerializerOptions<String> serializerOptions, @NotNull Function<Node<Object>, String> renderWithChildren) {
        return this.render(renderTo, node, false);
    }

    @Override
    public String renderAfterChildren(@Nullable String renderTo, @NotNull Node<Object> node, @NotNull MinecraftSerializerOptions<String> serializerOptions, @NotNull Function<Node<Object>, String> renderWithChildren) {
        return this.render(renderTo, node, true);
    }
}

