/*
 * Decompiled with CFR 0.152.
 */
package net.onelitefeather.antiredstoneclockremastered.service.tracking;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.onelitefeather.antiredstoneclockremastered.AntiRedstoneClockRemastered;
import net.onelitefeather.antiredstoneclockremastered.com.jeff_media.customblockdata.CustomBlockData;
import net.onelitefeather.antiredstoneclockremastered.model.DynamicRedstoneClock;
import net.onelitefeather.antiredstoneclockremastered.model.RedstoneClock;
import net.onelitefeather.antiredstoneclockremastered.service.api.RedstoneClockMiddleware;
import net.onelitefeather.antiredstoneclockremastered.service.api.RedstoneTrackingService;
import net.onelitefeather.antiredstoneclockremastered.utils.UUIDTagType;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class DynamicTrackingService
implements RedstoneTrackingService {
    private static final ComponentLogger LOGGER = ComponentLogger.logger(DynamicTrackingService.class);
    private static final NamespacedKey REDSTONE_CLOCK_METADATA_KEY = NamespacedKey.fromString((String)"antiredstoneclock:redstone_clock");
    private final ConcurrentHashMap<UUID, DynamicRedstoneClock> activeClockTesters = new ConcurrentHashMap();
    private final AntiRedstoneClockRemastered plugin;

    @Inject
    public DynamicTrackingService(AntiRedstoneClockRemastered plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean isRedstoneClock(@NotNull RedstoneClockMiddleware.CheckContext context) {
        RedstoneClockMiddleware.EventType eventType = context.eventType();
        Location location = context.location();
        boolean desiredState = Optional.ofNullable(context.state()).orElse(false);
        DynamicRedstoneClock clock = this.getClockByLocation(location);
        if (clock != null) {
            if (this.expireOrDestroyIfNeeded(clock)) {
                return true;
            }
            if (eventType == RedstoneClockMiddleware.EventType.REDSTONE_AND_REPEATER) {
                clock.incrementTriggerCount();
                clock.setCurrentLocation(location);
            } else {
                if (clock.isActive()) {
                    clock.incrementTriggerCount();
                    clock.setCurrentLocation(location);
                    clock.setActive(false);
                    return false;
                }
                clock.setActive(desiredState);
            }
        }
        this.addRedstoneClockTest(location);
        return false;
    }

    private boolean expireOrDestroyIfNeeded(@NotNull DynamicRedstoneClock clock) {
        if (clock.isTimeOut()) {
            this.removeClockByClock(clock);
            return false;
        }
        if (clock.getTriggerCount() >= this.plugin.getConfig().getInt("clock.maxCount", 150)) {
            this.removeClockByClock(clock);
            return true;
        }
        return false;
    }

    public void removeClockByClock(@NotNull DynamicRedstoneClock staticRedstoneClock) {
        this.removeClockByLocation(staticRedstoneClock.getCurrentLocation());
    }

    private DynamicRedstoneClock getClockByLocation(Location location) {
        Block block = location.getBlock();
        CustomBlockData customBlockData = new CustomBlockData(block, (Plugin)this.plugin);
        if (customBlockData.has(REDSTONE_CLOCK_METADATA_KEY)) {
            UUID uuid = customBlockData.get(REDSTONE_CLOCK_METADATA_KEY, UUIDTagType.UUID);
            return this.activeClockTesters.get(uuid);
        }
        return null;
    }

    public void addRedstoneClockTest(@NotNull Location location) {
        Block block = location.getBlock();
        CustomBlockData customBlockData = new CustomBlockData(block, (Plugin)this.plugin);
        if (customBlockData.has(REDSTONE_CLOCK_METADATA_KEY)) {
            return;
        }
        DynamicRedstoneClock dynamicRedstoneClock = new DynamicRedstoneClock(location, System.currentTimeMillis() / 1000L + (long)this.plugin.getConfig().getInt("clock.endDelay", 300));
        customBlockData.set(REDSTONE_CLOCK_METADATA_KEY, UUIDTagType.UUID, dynamicRedstoneClock.getUuid());
        this.activeClockTesters.put(dynamicRedstoneClock.getUuid(), dynamicRedstoneClock);
    }

    @Override
    public Collection<RedstoneClock> getRedstoneClocks() {
        return Collections.unmodifiableCollection(this.activeClockTesters.values());
    }

    @Override
    public void removeClockByLocation(Location location) {
        this.activeClockTesters.values().removeIf(dynamicRedstoneClock -> dynamicRedstoneClock.getCurrentLocation().equals((Object)location));
    }
}

