/*
 * Decompiled with CFR 0.152.
 */
package net.onelitefeather.antiredstoneclockremastered.service.notification;

import club.minnced.discord.webhook.WebhookClient;
import club.minnced.discord.webhook.send.WebhookEmbed;
import club.minnced.discord.webhook.send.WebhookEmbedBuilder;
import dev.vankka.mcdiscordreserializer.discord.DiscordSerializer;
import dev.vankka.mcdiscordreserializer.discord.DiscordSerializerOptions;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.onelitefeather.antiredstoneclockremastered.AntiRedstoneClockRemastered;
import net.onelitefeather.antiredstoneclockremastered.service.api.NotificationService;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DiscordNotificationService
implements NotificationService {
    private static final ComponentLogger LOGGER = ComponentLogger.logger(DiscordNotificationService.class);
    private final AntiRedstoneClockRemastered plugin;
    private final NotificationService notificationService;
    private final WebhookClient webhookClient;

    public DiscordNotificationService(@NotNull AntiRedstoneClockRemastered plugin, @Nullable NotificationService notificationService) {
        this.plugin = plugin;
        this.notificationService = notificationService;
        this.webhookClient = this.createWebHook();
    }

    private WebhookClient createWebHook() {
        if (this.plugin.getConfig().getString("notification.discord.webhook", "").isEmpty()) {
            return null;
        }
        if (!this.plugin.getConfig().getStringList("notification.enabled").contains("discord")) {
            return null;
        }
        try {
            URI.create(this.plugin.getConfig().getString("notification.discord.webhook", ""));
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Failed to create webhook client. Please check your webhook URL in the config.yml", (Throwable)e);
            Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
            return null;
        }
        try {
            return WebhookClient.withUrl(this.plugin.getConfig().getString("notification.discord.webhook", ""));
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Failed to create webhook client. Please check your webhook URL in the config.yml", (Throwable)e);
            Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
            return null;
        }
    }

    @Override
    public Component getNotificationMessage(@NotNull Location location) {
        return MiniMessage.miniMessage().deserialize(this.plugin.getConfig().getString("notification.discord.description", ""), new TagResolver[]{Placeholder.component((String)"x", (ComponentLike)Component.text(location.x())), Placeholder.component((String)"y", (ComponentLike)Component.text(location.y())), Placeholder.component((String)"z", (ComponentLike)Component.text(location.z())), Placeholder.component((String)"world", (ComponentLike)Component.text(location.getWorld().getName()))});
    }

    @Override
    public void sendNotificationMessage(@NotNull Location location) {
        if (this.notificationService != null) {
            this.notificationService.sendNotificationMessage(location);
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.webhookClient == null) {
            return;
        }
        WebhookEmbedBuilder embed = new WebhookEmbedBuilder().setColor(this.plugin.getConfig().getInt("notification.discord.color", 0xFF0000)).setDescription(DiscordSerializer.INSTANCE.serialize(this.getNotificationMessage(location), DiscordSerializerOptions.defaults().withEscapeMarkdown(false))).setImageUrl(this.plugin.getConfig().getString("notification.discord.image", ""));
        this.generateFields(location).forEach(embed::addField);
        this.webhookClient.send(embed.build(), new WebhookEmbed[0]).thenAccept(message -> LOGGER.debug("Sent notification to Discord"));
    }

    public List<WebhookEmbed.EmbedField> generateFields(Location location) {
        List configurationSection = this.plugin.getConfig().getMapList("notification.discord.fields");
        return configurationSection.stream().limit(5L).map(map -> FieldEntry.deserialize(map)).map(key -> {
            String name = key.getName();
            String value = key.getValue();
            Component miniMessageValue = MiniMessage.miniMessage().deserialize(value, new TagResolver[]{Placeholder.component((String)"x", (ComponentLike)Component.text(location.x())), Placeholder.component((String)"y", (ComponentLike)Component.text(location.y())), Placeholder.component((String)"z", (ComponentLike)Component.text(location.z())), Placeholder.component((String)"world", (ComponentLike)Component.text(location.getWorld().getName()))});
            boolean inline = key.isInline();
            return new WebhookEmbed.EmbedField(inline, name, DiscordSerializer.INSTANCE.serialize(miniMessageValue, DiscordSerializerOptions.defaults().withEscapeMarkdown(false)));
        }).toList();
    }

    @Override
    public boolean isEnabled() {
        return this.plugin.getConfig().getStringList("notification.enabled").contains("discord");
    }

    static class FieldEntry
    implements ConfigurationSerializable {
        private final String name;
        private final String value;
        private final boolean inline;

        private FieldEntry(String name, String value, boolean inline) {
            this.name = name;
            this.value = value;
            this.inline = inline;
        }

        @NotNull
        public Map<String, Object> serialize() {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("name", this.name);
            result.put("value", this.value);
            result.put("inline", this.inline);
            return result;
        }

        public static FieldEntry deserialize(Map<String, Object> args2) {
            String name = (String)args2.get("name");
            String value = (String)args2.get("value");
            boolean inline = (Boolean)args2.getOrDefault("inline", false);
            return new FieldEntry(name, value, inline);
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isInline() {
            return this.inline;
        }
    }
}

