/*
 * Decompiled with CFR 0.152.
 */
package net.onelitefeather.antiredstoneclockremastered.injection;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import net.onelitefeather.antiredstoneclockremastered.listener.ComparatorListener;
import net.onelitefeather.antiredstoneclockremastered.listener.ObserverListener;
import net.onelitefeather.antiredstoneclockremastered.listener.PistonListener;
import net.onelitefeather.antiredstoneclockremastered.listener.PlayerListener;
import net.onelitefeather.antiredstoneclockremastered.listener.RedstoneListener;
import net.onelitefeather.antiredstoneclockremastered.listener.SculkListener;
import net.onelitefeather.antiredstoneclockremastered.service.api.DecisionService;
import org.bukkit.Material;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public final class ListenerModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(PlayerListener.class);
        this.bind(ObserverListener.class);
        this.bind(SculkListener.class);
        this.bind(PistonListener.class);
    }

    private ComparatorListener createComparatorListener(Material material, DecisionService decisionService) {
        return new ComparatorListener(material, decisionService);
    }

    private RedstoneListener createRedstoneListener(Material material, DecisionService decisionService) {
        return new RedstoneListener(material, decisionService);
    }

    public void registerEvents(Injector injector, Plugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)injector.getInstance(PlayerListener.class), plugin);
        plugin.getServer().getPluginManager().registerEvents((Listener)injector.getInstance(ObserverListener.class), plugin);
        Material sculk = Material.getMaterial((String)"SCULK");
        if (sculk != null) {
            plugin.getServer().getPluginManager().registerEvents((Listener)injector.getInstance(SculkListener.class), plugin);
        }
        plugin.getServer().getPluginManager().registerEvents((Listener)injector.getInstance(PistonListener.class), plugin);
        Material comparator = Material.getMaterial((String)"COMPARATOR");
        if (comparator != null) {
            ComparatorListener listener = this.createComparatorListener(comparator, injector.getInstance(DecisionService.class));
            plugin.getServer().getPluginManager().registerEvents((Listener)listener, plugin);
        } else {
            ComparatorListener listener1 = this.createComparatorListener(Material.getMaterial((String)"REDSTONE_COMPARATOR_OFF"), injector.getInstance(DecisionService.class));
            ComparatorListener listener2 = this.createComparatorListener(Material.getMaterial((String)"REDSTONE_COMPARATOR_ON"), injector.getInstance(DecisionService.class));
            plugin.getServer().getPluginManager().registerEvents((Listener)listener1, plugin);
            plugin.getServer().getPluginManager().registerEvents((Listener)listener2, plugin);
        }
        Material repeater = Material.getMaterial((String)"REPEATER");
        if (repeater != null) {
            RedstoneListener listener = this.createRedstoneListener(repeater, injector.getInstance(DecisionService.class));
            plugin.getServer().getPluginManager().registerEvents((Listener)listener, plugin);
        } else {
            RedstoneListener listener1 = this.createRedstoneListener(Material.getMaterial((String)"DIODE_BLOCK_ON"), injector.getInstance(DecisionService.class));
            RedstoneListener listener2 = this.createRedstoneListener(Material.getMaterial((String)"DIODE_BLOCK_OFF"), injector.getInstance(DecisionService.class));
            plugin.getServer().getPluginManager().registerEvents((Listener)listener1, plugin);
            plugin.getServer().getPluginManager().registerEvents((Listener)listener2, plugin);
        }
    }
}

