/*
 * Decompiled with CFR 0.152.
 */
package net.onelitefeather.antiredstoneclockremastered.injection;

import com.github.zafarkhaja.semver.Version;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.papermc.paper.ServerBuildInfo;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.ResourceBundle;
import net.kyori.adventure.util.UTF8ResourceBundleControl;
import net.onelitefeather.antiredstoneclockremastered.AntiRedstoneClockRemastered;
import net.onelitefeather.antiredstoneclockremastered.service.api.TranslationService;
import net.onelitefeather.antiredstoneclockremastered.service.impl.LegacyTranslationService;
import net.onelitefeather.antiredstoneclockremastered.service.impl.ModernTranslationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TranslationModule
extends AbstractModule {
    private static final String RESOURCE_BUNDLE_NAME = "antiredstoneclockremasterd";
    private static final Logger LOGGER = LoggerFactory.getLogger(TranslationModule.class);

    @Override
    protected void configure() {
    }

    @Provides
    @Singleton
    public TranslationService provideTranslationService() {
        if (this.isLegacyVersion()) {
            LOGGER.info("Using legacy translation service");
            return new LegacyTranslationService();
        }
        LOGGER.info("Using modern translation service");
        return new ModernTranslationService();
    }

    private boolean isLegacyVersion() {
        ServerBuildInfo buildInfo = ServerBuildInfo.buildInfo();
        Optional<Version> optionalVersion = Version.tryParse(buildInfo.minecraftVersionId());
        if (optionalVersion.isEmpty()) {
            return true;
        }
        Version version = optionalVersion.get();
        if (version.isHigherThanOrEquivalentTo(Version.of(1L, 21L, 4L))) {
            return false;
        }
        return version.isLowerThanOrEquivalentTo(Version.of(1L, 21L, 3L));
    }

    @Inject
    public void bootstrap(AntiRedstoneClockRemastered plugin, TranslationService translationService) {
        Path langFolder = plugin.getDataFolder().toPath().resolve("lang");
        if (Files.notExists(langFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(langFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("An error occurred while creating lang folder");
                return;
            }
        }
        HashSet<String> languages = new HashSet<String>(plugin.getConfig().getStringList("translations"));
        languages.add("en-US");
        languages.stream().map(Locale::forLanguageTag).forEach(locale -> this.loadAndRegisterTranslation((Locale)locale, langFolder, translationService));
        translationService.registerGlobal();
    }

    private void loadAndRegisterTranslation(Locale locale, Path langFolder, TranslationService translationService) {
        try {
            ResourceBundle bundle = this.loadResourceBundle(locale, langFolder);
            if (bundle != null) {
                translationService.registerAll(locale, bundle, false);
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while loading language file for locale {}", (Object)locale, (Object)e);
        }
    }

    private ResourceBundle loadResourceBundle(Locale locale, Path langFolder) throws Exception {
        Path langFile = langFolder.resolve("antiredstoneclockremasterd_" + locale.toLanguageTag() + ".properties");
        if (Files.exists(langFile, new LinkOption[0])) {
            try (URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{langFolder.toUri().toURL()});){
                ResourceBundle resourceBundle = ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME, locale, urlClassLoader, UTF8ResourceBundleControl.get());
                return resourceBundle;
            }
        }
        return ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME, locale, UTF8ResourceBundleControl.get());
    }
}

