/*
 * Decompiled with CFR 0.152.
 */
package dev.vankka.simpleast.core.parser;

import dev.vankka.simpleast.core.ParseException;
import dev.vankka.simpleast.core.node.Node;
import dev.vankka.simpleast.core.parser.ParseSpec;
import dev.vankka.simpleast.core.parser.Rule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;

public class Parser<R, T extends Node<R>, S> {
    private final List<Rule<R, T, S>> rules = new ArrayList<Rule<R, T, S>>();
    private final boolean enableDebugging;

    public Parser(boolean enableDebugging) {
        this.enableDebugging = enableDebugging;
    }

    public Parser() {
        this.enableDebugging = false;
    }

    public Parser<R, T, S> addRule(Rule<R, T, S> rule) {
        this.rules.add(rule);
        return this;
    }

    public Parser<R, T, S> addRules(Collection<Rule<R, T, S>> rules) {
        this.rules.addAll(rules);
        return this;
    }

    public Parser<R, T, S> removeRule(Rule<R, T, S> rule) {
        this.rules.remove(rule);
        return this;
    }

    public Parser<R, T, S> removeRules(Collection<Rule<R, T, S>> rules) {
        this.rules.removeAll(rules);
        return this;
    }

    public List<Rule<R, T, S>> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public List<T> parse(CharSequence source2) {
        return this.parse(source2, null);
    }

    public List<T> parse(CharSequence source2, S initialSource) {
        return this.parse(source2, initialSource, this.rules);
    }

    public List<T> parse(CharSequence source2, S initialState, List<Rule<R, T, S>> rules) {
        return this.parse(source2, initialState, rules, this.enableDebugging);
    }

    public List<T> parse(CharSequence source2, S initialState, List<Rule<R, T, S>> rules, boolean enableDebugging) {
        ParseSpec builder;
        if (rules == null) {
            rules = this.rules;
        }
        Stack<ParseSpec<R, T, S>> remainingParses = new Stack<ParseSpec<R, T, S>>();
        Node topLevelRootNode = new Node<R>(){};
        String lastCapture = null;
        if (source2 != null && !source2.toString().isEmpty()) {
            remainingParses.add(new ParseSpec(topLevelRootNode, initialState, 0, source2.length()));
        }
        while (!remainingParses.isEmpty() && (builder = (ParseSpec)remainingParses.pop()).getStartIndex() < builder.getEndIndex()) {
            CharSequence inspectionSource = source2.subSequence(builder.getStartIndex(), builder.getEndIndex());
            int offset = builder.getStartIndex();
            boolean foundRule = false;
            for (Rule rule : rules) {
                Matcher matcher = rule.match(inspectionSource, lastCapture, builder.getState());
                if (matcher == null) {
                    if (!enableDebugging) continue;
                    System.out.println("MISS: with rule with pattern: " + rule.getMatcher().pattern().toString() + " to source: " + source2);
                    continue;
                }
                if (enableDebugging) {
                    System.out.println("MATCH: with rule with pattern: " + rule.getMatcher().pattern().toString() + " to source: " + source2 + " with match: " + matcher.toMatchResult());
                }
                foundRule = true;
                int matcherSourceEnd = matcher.end() + offset;
                ParseSpec<R, T, S> newBuilder = rule.parse(matcher, this, builder.getState());
                Object parent = builder.getRoot();
                ((Node)parent).addChild(newBuilder.getRoot());
                if (matcherSourceEnd != builder.getEndIndex()) {
                    remainingParses.push(ParseSpec.createNonterminal(parent, builder.getState(), matcherSourceEnd, builder.getEndIndex()));
                }
                if (!newBuilder.isTerminal()) {
                    newBuilder.applyOffset(offset);
                    remainingParses.push(newBuilder);
                }
                try {
                    lastCapture = matcher.group(0);
                    break;
                }
                catch (Throwable throwable) {
                    throw new ParseException("matcher found no matches", source2, throwable);
                }
            }
            if (foundRule) continue;
            throw new ParseException("failed to find rule to match source", inspectionSource);
        }
        return topLevelRootNode.getChildren();
    }
}

