/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.annotations;

import java.lang.reflect.Method;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.annotations.AnnotationParser;
import org.incendo.cloud.meta.CommandMeta;
import org.incendo.cloud.parser.ParserParameters;

class MetaFactory
implements Function<Method, CommandMeta> {
    private final AnnotationParser<?> annotationParser;
    private final Function<ParserParameters, CommandMeta> metaMapper;

    MetaFactory(@NonNull AnnotationParser<?> annotationParser, @NonNull Function<@NonNull ParserParameters, @NonNull CommandMeta> metaMapper) {
        this.annotationParser = annotationParser;
        this.metaMapper = metaMapper;
    }

    @Override
    public @NonNull CommandMeta apply(@NonNull Method method) {
        ParserParameters parameters = ParserParameters.empty();
        this.annotationParser.annotationMappers().forEach((annotationClass, mapper) -> {
            Object annotation = AnnotationParser.getMethodOrClassAnnotation(method, annotationClass);
            if (annotation != null) {
                parameters.merge(mapper.mapAnnotation(annotation));
            }
        });
        return this.metaMapper.apply(parameters);
    }
}

