/*
 * Decompiled with CFR 0.152.
 */
package net.onelitefeather.antiredstoneclockremastered.utils;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import net.onelitefeather.antiredstoneclockremastered.AntiRedstoneClockRemastered;
import net.onelitefeather.antiredstoneclockremastered.service.api.SchedulerService;

@Singleton
public final class CheckTPS {
    private long lastPoll = System.currentTimeMillis();
    private boolean tpsOk = true;
    private long tps = 20L;
    private final AntiRedstoneClockRemastered plugin;
    private final SchedulerService scheduler;
    private final int interval;
    private final int maximimumTPS;
    private final int minimumTPS;

    @Inject
    public CheckTPS(AntiRedstoneClockRemastered plugin, SchedulerService scheduler) {
        this.plugin = plugin;
        this.scheduler = scheduler;
        this.interval = plugin.getConfig().getInt("tps.interval", 2);
        this.maximimumTPS = plugin.getConfig().getInt("tps.max", 20);
        this.minimumTPS = plugin.getConfig().getInt("tps.min", 15);
    }

    public void startCheck() {
        if (this.minimumTPS > 0 || this.maximimumTPS > 0) {
            this.scheduler.scheduleRepeatingTask(this::runCheck, 1L, 20L * (long)this.interval);
        }
    }

    private void runCheck() {
        long current = System.currentTimeMillis();
        long spendTime = (current - this.lastPoll) / 1000L;
        if (spendTime <= 0L) {
            spendTime = 1L;
        }
        this.tps = 20L * (long)this.interval / spendTime;
        this.tpsOk = this.minimumTPS < 0 ? this.tps <= (long)this.maximimumTPS : (this.maximimumTPS < 0 ? this.tps >= (long)this.minimumTPS : this.tps >= (long)this.minimumTPS && this.tps <= (long)this.maximimumTPS);
        this.lastPoll = current;
    }

    public boolean isTpsOk() {
        return this.tpsOk;
    }

    public long getTps() {
        return this.tps;
    }
}

