/*
 * Decompiled with CFR 0.152.
 */
package net.onelitefeather.antiredstoneclockremastered.listener;

import jakarta.inject.Inject;
import net.kyori.adventure.text.Component;
import net.onelitefeather.antiredstoneclockremastered.AntiRedstoneClockRemastered;
import net.onelitefeather.antiredstoneclockremastered.service.UpdateService;
import net.onelitefeather.antiredstoneclockremastered.service.api.RedstoneClockService;
import net.onelitefeather.antiredstoneclockremastered.utils.Constants;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerJoinEvent;

public final class PlayerListener
implements Listener {
    private final RedstoneClockService redstoneClockService;
    private final UpdateService updateService;

    @Inject
    public PlayerListener(RedstoneClockService redstoneClockService, UpdateService updateService) {
        this.redstoneClockService = redstoneClockService;
        this.updateService = updateService;
    }

    @EventHandler
    private void onPlayerJoinEvent(PlayerJoinEvent playerJoinEvent) {
        Player player = playerJoinEvent.getPlayer();
        if (player.isOp() || player.hasPermission("antiredstoneclockremastered.notify.admin") && !player.hasPermission("antiredstoneclockremastered.notify.disable.donation")) {
            player.sendMessage((Component)Component.translatable("antiredstoneclockremastered.notify.donation.player").arguments(AntiRedstoneClockRemastered.PREFIX));
        }
        if (player.isOp() || player.hasPermission("antiredstoneclockremastered.notify.admin.update")) {
            this.updateService.notifyPlayer(player);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    private void onBlockBreak(BlockBreakEvent blockBreakEvent) {
        Block block = blockBreakEvent.getBlock();
        if (Constants.REDSTONE_ITEMS.contains(block.getType())) {
            this.redstoneClockService.removeClockByLocation(block.getLocation());
        } else {
            block = block.getRelative(BlockFace.UP);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    private void onSignBlockBreak(BlockBreakEvent blockBreakEvent) {
        Block block = blockBreakEvent.getBlock();
        boolean hasKey = block.hasMetadata("arcr-sign");
        if (hasKey) {
            blockBreakEvent.setDropItems(false);
        }
    }
}

