/*
 * Decompiled with CFR 0.152.
 */
package net.onelitefeather.antiredstoneclockremastered.injection;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import net.kyori.adventure.text.Component;
import net.onelitefeather.antiredstoneclockremastered.commands.DisplayActiveClocksCommand;
import net.onelitefeather.antiredstoneclockremastered.commands.FeatureCommand;
import net.onelitefeather.antiredstoneclockremastered.commands.ReloadCommand;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.incendo.cloud.annotations.AnnotationParser;
import org.incendo.cloud.bukkit.CloudBukkitCapabilities;
import org.incendo.cloud.component.DefaultValue;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.minecraft.extras.MinecraftHelp;
import org.incendo.cloud.minecraft.extras.RichDescription;
import org.incendo.cloud.paper.LegacyPaperCommandManager;
import org.incendo.cloud.parser.standard.StringParser;

@Singleton
public class CommandFrameworkModule {
    private final JavaPlugin plugin;
    private final Injector injector;
    private AnnotationParser<CommandSender> annotationParser;

    @Inject
    public CommandFrameworkModule(JavaPlugin plugin, Injector injector) {
        this.plugin = plugin;
        this.injector = injector;
    }

    public void enable() {
        LegacyPaperCommandManager<CommandSender> commandManager = LegacyPaperCommandManager.createNative((Plugin)this.plugin, ExecutionCoordinator.asyncCoordinator());
        if (commandManager.hasCapability(CloudBukkitCapabilities.NATIVE_BRIGADIER)) {
            commandManager.registerBrigadier();
        } else if (commandManager.hasCapability(CloudBukkitCapabilities.ASYNCHRONOUS_COMPLETION)) {
            commandManager.registerAsynchronousCompletions();
        }
        this.annotationParser = new AnnotationParser<CommandSender>(commandManager, CommandSender.class);
        this.annotationParser.descriptionMapper(string -> RichDescription.of(Component.translatable(string)));
        MinecraftHelp<CommandSender> help = MinecraftHelp.create("/arcm help", commandManager, sender -> sender);
        commandManager.command(commandManager.commandBuilder("arcm", new String[0]).literal("help", new String[0]).permission("antiredstoneclockremastered.command.help").optional("query", StringParser.greedyStringParser(), DefaultValue.constant("")).handler(context -> help.queryCommands((String)context.get("query"), (CommandSender)context.sender())));
        this.registerCommands();
    }

    private void registerCommands() {
        if (this.annotationParser != null) {
            this.annotationParser.parse(this.injector.getInstance(ReloadCommand.class));
            this.annotationParser.parse(this.injector.getInstance(DisplayActiveClocksCommand.class));
            this.annotationParser.parse(this.injector.getInstance(FeatureCommand.class));
        }
    }
}

