/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.minecraft.extras.suggestion;

import java.util.Objects;
import net.kyori.adventure.text.Component;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Generated;
import org.incendo.cloud.minecraft.extras.suggestion.ComponentTooltipSuggestion;

@API(status=API.Status.INTERNAL, consumers={"org.incendo.cloud.*"})
@Generated(from="ComponentTooltipSuggestion", generator="Immutables")
final class ComponentTooltipSuggestionImpl
implements ComponentTooltipSuggestion {
    private final @NonNull String suggestion;
    private final @Nullable Component tooltip;

    private ComponentTooltipSuggestionImpl(@NonNull String suggestion, @Nullable Component tooltip) {
        this.suggestion = Objects.requireNonNull(suggestion, "suggestion");
        this.tooltip = tooltip;
    }

    private ComponentTooltipSuggestionImpl(ComponentTooltipSuggestionImpl original, @NonNull String suggestion, @Nullable Component tooltip) {
        this.suggestion = suggestion;
        this.tooltip = tooltip;
    }

    @Override
    public @NonNull String suggestion() {
        return this.suggestion;
    }

    @Override
    public @Nullable Component tooltip() {
        return this.tooltip;
    }

    @Override
    public final ComponentTooltipSuggestionImpl withSuggestion(@NonNull String value) {
        @NonNull String newValue = Objects.requireNonNull(value, "suggestion");
        if (this.suggestion.equals(newValue)) {
            return this;
        }
        return new ComponentTooltipSuggestionImpl(this, newValue, this.tooltip);
    }

    public final ComponentTooltipSuggestionImpl withTooltip(@Nullable Component value) {
        if (this.tooltip == value) {
            return this;
        }
        return new ComponentTooltipSuggestionImpl(this, this.suggestion, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ComponentTooltipSuggestionImpl && this.equalTo(0, (ComponentTooltipSuggestionImpl)another);
    }

    private boolean equalTo(int synthetic, ComponentTooltipSuggestionImpl another) {
        return this.suggestion.equals(another.suggestion) && Objects.equals(this.tooltip, another.tooltip);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.suggestion.hashCode();
        h += (h << 5) + Objects.hashCode(this.tooltip);
        return h;
    }

    public String toString() {
        return "ComponentTooltipSuggestion{suggestion=" + this.suggestion + ", tooltip=" + this.tooltip + "}";
    }

    public static ComponentTooltipSuggestionImpl of(@NonNull String suggestion, @Nullable Component tooltip) {
        return new ComponentTooltipSuggestionImpl(suggestion, tooltip);
    }

    public static ComponentTooltipSuggestionImpl copyOf(ComponentTooltipSuggestion instance) {
        if (instance instanceof ComponentTooltipSuggestionImpl) {
            return (ComponentTooltipSuggestionImpl)instance;
        }
        return ComponentTooltipSuggestionImpl.of(instance.suggestion(), instance.tooltip());
    }
}

