/*
 * Decompiled with CFR 0.152.
 */
package net.onelitefeather.antiredstoneclockremastered.utils;

import org.bukkit.plugin.Plugin;

public final class CheckTPS {
    private long lastPoll = System.currentTimeMillis();
    private boolean tpsOk = true;
    private long tps = 20L;
    private final Plugin plugin;
    private final int interval;
    private final int maximimumTPS;
    private final int minimumTPS;

    public CheckTPS(Plugin plugin, int interval, int maximimumTPS, int minimumTPS) {
        this.plugin = plugin;
        this.interval = interval;
        this.maximimumTPS = maximimumTPS;
        this.minimumTPS = minimumTPS;
    }

    public void startCheck() {
        if (this.minimumTPS > 0 || this.maximimumTPS > 0) {
            this.plugin.getServer().getScheduler().runTaskTimer(this.plugin, this::runCheck, 0L, 20L * (long)this.interval);
        }
    }

    private void runCheck() {
        long current = System.currentTimeMillis();
        long spendTime = (current - this.lastPoll) / 1000L;
        if (spendTime <= 0L) {
            spendTime = 1L;
        }
        this.tps = 20L * (long)this.interval / spendTime;
        this.tpsOk = this.minimumTPS < 0 ? this.tps <= (long)this.maximimumTPS : (this.maximimumTPS < 0 ? this.tps >= (long)this.minimumTPS : this.tps >= (long)this.minimumTPS && this.tps <= (long)this.maximimumTPS);
        this.lastPoll = current;
    }

    public boolean isTpsOk() {
        return this.tpsOk;
    }

    public long getTps() {
        return this.tps;
    }
}

