/*
 * Decompiled with CFR 0.152.
 */
package net.onelitefeather.antiredstoneclockremastered.translations;

import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.ParsingException;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.translation.TranslationRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginTranslationRegistry
implements TranslationRegistry {
    private final TranslationRegistry backedRegistry;

    public PluginTranslationRegistry(TranslationRegistry backedRegistry) {
        this.backedRegistry = backedRegistry;
    }

    @Override
    public boolean contains(@NotNull String key) {
        return this.backedRegistry.contains(key);
    }

    @Override
    @NotNull
    public Key name() {
        return this.backedRegistry.name();
    }

    @Override
    @Nullable
    public MessageFormat translate(@NotNull String key, @NotNull Locale locale) {
        return null;
    }

    @Override
    @Nullable
    public Component translate(@NotNull TranslatableComponent component, @NotNull Locale locale) {
        MessageFormat translationFormat = this.backedRegistry.translate(component.key(), locale);
        if (translationFormat == null) {
            return null;
        }
        String miniMessageString = translationFormat.toPattern();
        Object resultingComponent = component.arguments().isEmpty() ? MiniMessage.miniMessage().deserialize(miniMessageString) : MiniMessage.miniMessage().deserialize(miniMessageString, (TagResolver)new ArgumentTag(component.arguments()));
        if (component.children().isEmpty()) {
            return resultingComponent;
        }
        return resultingComponent.children(component.children());
    }

    @Override
    public void defaultLocale(@NotNull Locale locale) {
        this.backedRegistry.defaultLocale(locale);
    }

    @Override
    public void register(@NotNull String key, @NotNull Locale locale, @NotNull MessageFormat format) {
        this.backedRegistry.register(key, locale, format);
    }

    @Override
    public void unregister(@NotNull String key) {
        this.backedRegistry.unregister(key);
    }

    private static final class ArgumentTag
    implements TagResolver {
        private static final String NAME = "argument";
        private static final String NAME_1 = "arg";
        private final List<? extends ComponentLike> argumentComponents;

        private ArgumentTag(@NotNull List<? extends ComponentLike> argumentComponents) {
            this.argumentComponents = Objects.requireNonNull(argumentComponents, "argumentComponents");
        }

        @Override
        public Tag resolve(@NotNull String name, @NotNull ArgumentQueue arguments, @NotNull Context ctx) throws ParsingException {
            int index = arguments.popOr("No argument number provided").asInt().orElseThrow(() -> ctx.newException("Invalid argument number", arguments));
            if (index < 0 || index >= this.argumentComponents.size()) {
                throw ctx.newException("Invalid argument number", arguments);
            }
            return Tag.inserting(this.argumentComponents.get(index));
        }

        @Override
        public boolean has(@NotNull String name) {
            return name.equals(NAME) || name.equals(NAME_1);
        }
    }
}

