/*
 * Decompiled with CFR 0.152.
 */
package net.onelitefeather.antiredstoneclockremastered.commands;

import java.util.Collection;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.feature.pagination.Pagination;
import net.onelitefeather.antiredstoneclockremastered.AntiRedstoneClockRemastered;
import net.onelitefeather.antiredstoneclockremastered.model.RedstoneClock;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.incendo.cloud.annotation.specifier.Greedy;
import org.incendo.cloud.annotations.Argument;
import org.incendo.cloud.annotations.Command;
import org.incendo.cloud.annotations.CommandDescription;
import org.incendo.cloud.annotations.Permission;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DisplayActiveClocksCommand
implements Pagination.Renderer.RowRenderer<RedstoneClock> {
    private final AntiRedstoneClockRemastered plugin;
    private final Pagination.Builder pagination = Pagination.builder().resultsPerPage(4);

    public DisplayActiveClocksCommand(AntiRedstoneClockRemastered plugin) {
        this.plugin = plugin;
    }

    @Command(value="arcm display [page]")
    @CommandDescription(value="antiredstoneclockremastered.command.display.description")
    @Permission(value={"antiredstoneclockremastered.command.display"})
    public void displayClocks(CommandSender commandSender, @Greedy @Argument(value="page") Integer page) {
        Pagination<RedstoneClock> build = this.pagination.build(AntiRedstoneClockRemastered.PREFIX, this, this::mapToCommand);
        if (page == null) {
            page = 0;
        }
        build.render(this.plugin.getRedstoneClockService().getRedstoneClocks(), Math.max(1, page)).forEach(arg_0 -> commandSender.sendMessage(arg_0));
    }

    private String mapToCommand(int i) {
        return "/arcm display " + i;
    }

    private Component mapClockToMessage(RedstoneClock redstoneClock) {
        Location location = redstoneClock.getLocation();
        return ((TextComponent)Component.empty().hoverEvent((HoverEventSource)Component.translatable("antiredstoneclockremastered.command.display.clock.hover").asHoverEvent())).append(Component.translatable("antiredstoneclockremastered.command.display.clock.text").arguments(TranslationArgument.numeric(redstoneClock.getTriggerCount()), TranslationArgument.numeric(location.getBlockX()), TranslationArgument.numeric(location.getBlockY()), TranslationArgument.numeric(location.getBlockZ()), Component.empty().clickEvent(ClickEvent.callback(audience -> {
            if (audience instanceof Player) {
                Player executor = (Player)audience;
                executor.teleport(location);
            }
        }))));
    }

    @Override
    @NotNull
    public Collection<Component> renderRow(@Nullable RedstoneClock redstoneClock, int index) {
        return List.of(this.mapClockToMessage(redstoneClock));
    }
}

