/*
 * Decompiled with CFR 0.152.
 */
package net.onelitefeather.antiredstoneclockremastered;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.TranslationRegistry;
import net.kyori.adventure.util.UTF8ResourceBundleControl;
import net.onelitefeather.antiredstoneclockremastered.api.PlotsquaredSupport;
import net.onelitefeather.antiredstoneclockremastered.api.WorldGuardSupport;
import net.onelitefeather.antiredstoneclockremastered.commands.DisplayActiveClocksCommand;
import net.onelitefeather.antiredstoneclockremastered.commands.FeatureCommand;
import net.onelitefeather.antiredstoneclockremastered.commands.ReloadCommand;
import net.onelitefeather.antiredstoneclockremastered.listener.ComparatorListener;
import net.onelitefeather.antiredstoneclockremastered.listener.ObserverListener;
import net.onelitefeather.antiredstoneclockremastered.listener.PistonListener;
import net.onelitefeather.antiredstoneclockremastered.listener.PlayerListener;
import net.onelitefeather.antiredstoneclockremastered.listener.RedstoneListener;
import net.onelitefeather.antiredstoneclockremastered.listener.SculkListener;
import net.onelitefeather.antiredstoneclockremastered.org.bstats.bukkit.Metrics;
import net.onelitefeather.antiredstoneclockremastered.org.bstats.charts.DrilldownPie;
import net.onelitefeather.antiredstoneclockremastered.org.bstats.charts.SimplePie;
import net.onelitefeather.antiredstoneclockremastered.plotsquared.v6.PlotSquaredLegacySupport;
import net.onelitefeather.antiredstoneclockremastered.plotsquared.v7.PlotSquaredModernSupport;
import net.onelitefeather.antiredstoneclockremastered.service.RedstoneClockService;
import net.onelitefeather.antiredstoneclockremastered.service.UpdateService;
import net.onelitefeather.antiredstoneclockremastered.translations.PluginTranslationRegistry;
import net.onelitefeather.antiredstoneclockremastered.utils.CheckTPS;
import net.onelitefeather.antiredstoneclockremastered.worldguard.v6.WorldGuardLegacySupport;
import net.onelitefeather.antiredstoneclockremastered.worldguard.v7.WorldGuardModernSupport;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.incendo.cloud.annotations.AnnotationParser;
import org.incendo.cloud.bukkit.CloudBukkitCapabilities;
import org.incendo.cloud.component.DefaultValue;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.minecraft.extras.MinecraftHelp;
import org.incendo.cloud.minecraft.extras.RichDescription;
import org.incendo.cloud.paper.LegacyPaperCommandManager;
import org.incendo.cloud.parser.standard.StringParser;

public final class AntiRedstoneClockRemastered
extends JavaPlugin {
    private CheckTPS tps;
    private RedstoneClockService redstoneClockService;
    private WorldGuardSupport worldGuardSupport;
    private PlotsquaredSupport plotsquaredSupport;
    private Metrics metrics;
    private AnnotationParser<CommandSender> annotationParser;
    public static final Component PREFIX = MiniMessage.miniMessage().deserialize("<gradient:red:white>[AntiRedstoneClock]</gradient>");
    private UpdateService updateService;

    public void onLoad() {
        this.saveDefaultConfig();
        this.reloadConfig();
        this.enableWorldGuardSupport();
    }

    public void onEnable() {
        PluginTranslationRegistry translationRegistry;
        block8: {
            translationRegistry = new PluginTranslationRegistry(TranslationRegistry.create(Key.key("antiredstoneclockremastered", "translations")));
            translationRegistry.defaultLocale(Locale.US);
            Path langFolder = this.getDataFolder().toPath().resolve("lang");
            HashSet<String> languages = new HashSet<String>(this.getConfig().getStringList("translations"));
            languages.add("en-US");
            if (Files.exists(langFolder, new LinkOption[0])) {
                try (URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{langFolder.toUri().toURL()});){
                    languages.stream().map(Locale::forLanguageTag).forEach(r -> {
                        ResourceBundle bundle = ResourceBundle.getBundle("antiredstoneclockremasterd", r, urlClassLoader, UTF8ResourceBundleControl.get());
                        translationRegistry.registerAll((Locale)r, bundle, false);
                    });
                    break block8;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            languages.stream().map(Locale::forLanguageTag).forEach(r -> {
                ResourceBundle bundle = ResourceBundle.getBundle("antiredstoneclockremasterd", r, UTF8ResourceBundleControl.get());
                translationRegistry.registerAll((Locale)r, bundle, false);
            });
        }
        GlobalTranslator.translator().addSource(translationRegistry);
        this.donationInformation();
        this.updateService();
        this.enableCommandFramework();
        this.enablePlotsquaredSupport();
        this.enableTPSChecker();
        this.enableRedstoneClockService();
        this.enableBStatsSupport();
        this.registerEvents();
        this.registerCommands();
    }

    private void updateService() {
        this.updateService = new UpdateService(this);
        this.updateService.run();
        this.updateService.notifyConsole(this.getComponentLogger());
    }

    public void onDisable() {
        this.updateService.shutdown();
    }

    private void donationInformation() {
        this.getComponentLogger().info((Component)Component.translatable("antiredstoneclockremastered.notify.donation.console"));
    }

    private void registerCommands() {
        if (this.annotationParser != null) {
            this.annotationParser.parse(new ReloadCommand(this));
            this.annotationParser.parse(new DisplayActiveClocksCommand(this));
            this.annotationParser.parse(new FeatureCommand(this));
        }
    }

    private void enableCommandFramework() {
        LegacyPaperCommandManager<CommandSender> commandManager = LegacyPaperCommandManager.createNative((Plugin)this, ExecutionCoordinator.asyncCoordinator());
        if (commandManager.hasCapability(CloudBukkitCapabilities.NATIVE_BRIGADIER)) {
            commandManager.registerBrigadier();
        } else if (commandManager.hasCapability(CloudBukkitCapabilities.ASYNCHRONOUS_COMPLETION)) {
            commandManager.registerAsynchronousCompletions();
        }
        this.annotationParser = new AnnotationParser<CommandSender>(commandManager, CommandSender.class);
        this.annotationParser.descriptionMapper(string -> RichDescription.of(Component.translatable(string)));
        MinecraftHelp<CommandSender> help = MinecraftHelp.create("/arcm help", commandManager, sender -> sender);
        commandManager.command(commandManager.commandBuilder("arcm", new String[0]).literal("help", new String[0]).permission("antiredstoneclockremastered.command.help").optional("query", StringParser.greedyStringParser(), DefaultValue.constant("")).handler(context -> help.queryCommands((String)context.get("query"), (CommandSender)context.sender())));
    }

    private void enablePlotsquaredSupport() {
        Plugin plugin = this.getServer().getPluginManager().getPlugin("PlotSquared");
        if (plugin == null) {
            this.getLogger().warning("PlotSquared hasn't been found!");
            return;
        }
        int psVersion = Integer.parseInt(plugin.getDescription().getVersion().split("\\.")[0]);
        if (psVersion < 6) {
            this.getLogger().warning("We don't support PS5 currently also you use a unsupported version of PlotSquared!!!");
            return;
        }
        if (psVersion < 7) {
            this.getLogger().warning("You use a legacy version of PlotSquared!");
            this.plotsquaredSupport = new PlotSquaredLegacySupport();
        } else {
            this.getLogger().info("Thanks to hold your software up-to date <3");
            this.plotsquaredSupport = new PlotSquaredModernSupport();
        }
        this.plotsquaredSupport.init();
    }

    private void enableWorldGuardSupport() {
        Plugin plugin = this.getServer().getPluginManager().getPlugin("WorldGuard");
        if (plugin == null) {
            this.getLogger().warning("WorldGuard hasn't been found!");
            return;
        }
        int wgVersion = Integer.parseInt(plugin.getDescription().getVersion().split("\\.")[0]);
        this.worldGuardSupport = wgVersion > 6 ? new WorldGuardModernSupport((Plugin)this) : new WorldGuardLegacySupport((Plugin)this);
        if (this.worldGuardSupport.registerFlag()) {
            this.getLogger().info("Flag redstoneclock registered");
        } else {
            this.getLogger().severe("An error occurred while registering redstoneclock flag");
        }
    }

    private void registerEvents() {
        Material sculk;
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this.redstoneClockService, this), (Plugin)this);
        if (this.getConfig().getBoolean("check.observer", true)) {
            this.getServer().getPluginManager().registerEvents((Listener)new ObserverListener(this), (Plugin)this);
        }
        if (this.getConfig().getBoolean("check.sculk", true) && (sculk = Material.getMaterial((String)"SCULK")) != null) {
            this.getServer().getPluginManager().registerEvents((Listener)new SculkListener(this), (Plugin)this);
        }
        if (this.getConfig().getBoolean("check.piston", true)) {
            this.getServer().getPluginManager().registerEvents((Listener)new PistonListener(this), (Plugin)this);
        }
        if (this.getConfig().getBoolean("check.comparator", true)) {
            Material comparator = Material.getMaterial((String)"COMPARATOR");
            if (comparator != null) {
                this.getServer().getPluginManager().registerEvents((Listener)new ComparatorListener(comparator, this), (Plugin)this);
            } else {
                this.getServer().getPluginManager().registerEvents((Listener)new ComparatorListener(Material.getMaterial((String)"REDSTONE_COMPARATOR_OFF"), this), (Plugin)this);
                this.getServer().getPluginManager().registerEvents((Listener)new ComparatorListener(Material.getMaterial((String)"REDSTONE_COMPARATOR_ON"), this), (Plugin)this);
            }
        }
        if (this.getConfig().getBoolean("check.redstoneAndRepeater", true)) {
            Material repeater = Material.getMaterial((String)"REPEATER");
            if (repeater != null) {
                this.getServer().getPluginManager().registerEvents((Listener)new RedstoneListener(repeater, this), (Plugin)this);
            } else {
                this.getServer().getPluginManager().registerEvents((Listener)new RedstoneListener(Material.getMaterial((String)"DIODE_BLOCK_ON"), this), (Plugin)this);
                this.getServer().getPluginManager().registerEvents((Listener)new RedstoneListener(Material.getMaterial((String)"DIODE_BLOCK_OFF"), this), (Plugin)this);
            }
        }
    }

    private void enableRedstoneClockService() {
        this.redstoneClockService = new RedstoneClockService(this);
    }

    private void enableTPSChecker() {
        this.tps = new CheckTPS((Plugin)this, this.getConfig().getInt("tps.interval", 2), this.getConfig().getInt("tps.max", 20), this.getConfig().getInt("tps.min", 15));
        this.tps.startCheck();
    }

    private void enableBStatsSupport() {
        this.metrics = new Metrics((Plugin)this, 19085);
        this.metrics.addCustomChart(new SimplePie("worldguard", this::bstatsWorldGuardVersion));
        this.metrics.addCustomChart(new SimplePie("plotsquared", this::bstatsPlotSquaredVersion));
        this.metrics.addCustomChart(new DrilldownPie("maxcount", this::bstatsMaxCount));
    }

    private Map<String, Map<String, Integer>> bstatsMaxCount() {
        HashMap<String, Map<String, Integer>> map = new HashMap<String, Map<String, Integer>>();
        int count = this.getConfig().getInt("clock.maxCount");
        Map<String, Integer> entry = Map.of(String.valueOf(count), 1);
        switch (count) {
            case 0: {
                map.put("0 \ud83d\udeab", entry);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                map.put("1-5 \ud83d\ude10", entry);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                map.put("6-10 \ud83d\ude42", entry);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                map.put("11-25 \ud83d\ude0a", entry);
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                map.put("26-50 \ud83d\ude00", entry);
                break;
            }
            default: {
                map.put("50+ \ud83d\ude01", entry);
            }
        }
        return map;
    }

    private String bstatsPlotSquaredVersion() {
        if (this.plotsquaredSupport != null) {
            return this.plotsquaredSupport.getVersion();
        }
        return "unknown";
    }

    private String bstatsWorldGuardVersion() {
        if (this.worldGuardSupport != null) {
            return this.worldGuardSupport.getVersion();
        }
        return "unknown";
    }

    public CheckTPS getTps() {
        return this.tps;
    }

    public RedstoneClockService getRedstoneClockService() {
        return this.redstoneClockService;
    }

    public WorldGuardSupport getWorldGuardSupport() {
        return this.worldGuardSupport;
    }

    public PlotsquaredSupport getPlotsquaredSupport() {
        return this.plotsquaredSupport;
    }

    public UpdateService getUpdateService() {
        return this.updateService;
    }
}

