/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancysitula.versions.v1_21_9.utils;

import de.oliver.fancysitula.api.packets.FS_ServerboundCustomClickActionPacket;
import de.oliver.fancysitula.api.packets.FS_ServerboundPacket;
import de.oliver.fancysitula.api.utils.FS_PacketListener;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerboundCustomClickActionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class PacketListenerImpl
extends FS_PacketListener {
    private static final String PIPELINE_NAME = "fancysitula-packet-injector";

    public PacketListenerImpl(FS_ServerboundPacket.Type packet) {
        super(packet);
    }

    @Override
    public void inject(final Player player) {
        ServerPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        Channel channel = serverPlayer.connection.connection.channel;
        if (channel.pipeline().get(PIPELINE_NAME) != null) {
            return;
        }
        channel.pipeline().addAfter("decoder", PIPELINE_NAME, (ChannelHandler)new MessageToMessageDecoder<Packet<?>>(){

            protected void decode(ChannelHandlerContext ctx, Packet<?> msg, List<Object> out) {
                out.add(msg);
                FS_ServerboundPacket.Type packetType = PacketListenerImpl.this.getPacketType(msg);
                if (packetType == null) {
                    return;
                }
                if (PacketListenerImpl.this.packet == FS_ServerboundPacket.Type.ALL) {
                    FS_ServerboundPacket fsPacket = PacketListenerImpl.this.convert(packetType, msg);
                    FS_PacketListener.PacketReceivedEvent packetReceivedEvent = new FS_PacketListener.PacketReceivedEvent(fsPacket, player);
                    PacketListenerImpl.this.listeners.forEach(listener -> listener.accept(packetReceivedEvent));
                    return;
                }
                if (PacketListenerImpl.this.packet == packetType) {
                    FS_ServerboundPacket fsPacket = PacketListenerImpl.this.convert(packetType, msg);
                    FS_PacketListener.PacketReceivedEvent packetReceivedEvent = new FS_PacketListener.PacketReceivedEvent(fsPacket, player);
                    PacketListenerImpl.this.listeners.forEach(listener -> listener.accept(packetReceivedEvent));
                }
            }
        });
    }

    private FS_ServerboundPacket.Type getPacketType(Packet<?> packet) {
        String className = packet.getClass().getSimpleName();
        for (FS_ServerboundPacket.Type type : FS_ServerboundPacket.Type.values()) {
            if (!type.getPacketClassName().equalsIgnoreCase(className)) continue;
            return type;
        }
        return null;
    }

    private FS_ServerboundPacket convert(FS_ServerboundPacket.Type type, Packet<?> packet) {
        switch (type) {
            case CUSTOM_CLICK_ACTION: {
                ServerboundCustomClickActionPacket customClickActionPacket = (ServerboundCustomClickActionPacket)packet;
                HashMap<String, String> payload = new HashMap<String, String>();
                if (customClickActionPacket.payload().isPresent() && ((Tag)customClickActionPacket.payload().get()).asCompound().isPresent()) {
                    ((CompoundTag)((Tag)customClickActionPacket.payload().get()).asCompound().get()).forEach((k, v) -> {
                        if (v.getType().getName().equals(StringTag.TYPE.getName())) {
                            if (v.asString().isPresent()) {
                                payload.put((String)k, (String)v.asString().get());
                            }
                        } else if (v.getType().getName().equals(ByteTag.TYPE.getName())) {
                            if (v.asBoolean().isPresent()) {
                                payload.put((String)k, String.valueOf(v.asBoolean().get()));
                            } else if (v.asByte().isPresent()) {
                                payload.put((String)k, String.valueOf(v.asByte().get()));
                            }
                        } else {
                            payload.put((String)k, v.toString());
                        }
                    });
                }
                return new FS_ServerboundCustomClickActionPacket(type, PaperAdventure.asAdventure((ResourceLocation)customClickActionPacket.id()), payload);
            }
        }
        throw new IllegalArgumentException("Unsupported packet type: " + String.valueOf((Object)type));
    }
}

