/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancysitula.versions.v1_21_11.packets;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import de.oliver.fancysitula.api.entities.FS_RealPlayer;
import de.oliver.fancysitula.api.packets.FS_ClientboundSetEntityDataPacket;
import de.oliver.fancysitula.api.utils.FS_GameProfile;
import de.oliver.fancysitula.api.utils.reflections.ReflectionUtils;
import de.oliver.fancysitula.versions.v1_21_11.utils.GameProfileImpl;
import de.oliver.fancysitula.versions.v1_21_11.utils.VanillaPlayerAdapter;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.kyori.adventure.text.Component;
import net.minecraft.core.ClientAsset;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Interaction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.bee.Bee;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.chicken.Chicken;
import net.minecraft.world.entity.animal.cow.Cow;
import net.minecraft.world.entity.animal.cow.MushroomCow;
import net.minecraft.world.entity.animal.equine.Horse;
import net.minecraft.world.entity.animal.equine.Llama;
import net.minecraft.world.entity.animal.feline.Cat;
import net.minecraft.world.entity.animal.fish.TropicalFish;
import net.minecraft.world.entity.animal.fox.Fox;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.panda.Panda;
import net.minecraft.world.entity.animal.parrot.Parrot;
import net.minecraft.world.entity.animal.pig.Pig;
import net.minecraft.world.entity.animal.polarbear.PolarBear;
import net.minecraft.world.entity.animal.rabbit.Rabbit;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.animal.turtle.Turtle;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.Mannequin;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.illager.SpellcasterIllager;
import net.minecraft.world.entity.npc.villager.Villager;
import net.minecraft.world.entity.npc.villager.VillagerData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelType;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.component.ResolvableProfile;
import org.bukkit.Bukkit;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.inventory.ItemStack;

public class ClientboundSetEntityDataPacketImpl
extends FS_ClientboundSetEntityDataPacket {
    private static final ConcurrentMap<String, Class<?>> ENTITY_CLASS_CACHE = new ConcurrentHashMap();
    private static final ConcurrentMap<String, EntityDataAccessor<Object>> ENTITY_ACCESSOR_CACHE = new ConcurrentHashMap<String, EntityDataAccessor<Object>>();

    public ClientboundSetEntityDataPacketImpl(int entityId, List<FS_ClientboundSetEntityDataPacket.EntityData> entityData) {
        super(entityId, entityData);
    }

    private static String translateFieldName(String entityClassName, String fieldName) {
        if (fieldName.equals("DATA_REMAINING_ANGER_TIME")) {
            return "DATA_ANGER_END_TIME";
        }
        return fieldName;
    }

    private static String translateClassName(String entityClassName, String fieldName) {
        if (entityClassName.equals("net.minecraft.world.entity.player.Player") && (fieldName.equals("DATA_PLAYER_MODE_CUSTOMISATION") || fieldName.equals("DATA_PLAYER_MAIN_HAND"))) {
            return "net.minecraft.world.entity.Avatar";
        }
        return entityClassName;
    }

    private static Class<?> getEntityClassCached(String className) throws ClassNotFoundException {
        Class cached = (Class)ENTITY_CLASS_CACHE.get(className);
        if (cached != null) {
            return cached;
        }
        ClassLoader classLoader = MinecraftServer.class.getClassLoader();
        Class<?> resolved = classLoader.loadClass(className);
        ENTITY_CLASS_CACHE.put(className, resolved);
        return resolved;
    }

    private static EntityDataAccessor<Object> getAccessorCached(String entityClassName, String fieldName) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        String key = entityClassName + "#" + fieldName;
        EntityDataAccessor cached = (EntityDataAccessor)ENTITY_ACCESSOR_CACHE.get(key);
        if (cached != null) {
            return cached;
        }
        Class<?> entityClass = ClientboundSetEntityDataPacketImpl.getEntityClassCached(entityClassName);
        EntityDataAccessor accessor = (EntityDataAccessor)ReflectionUtils.getStaticField(entityClass, fieldName);
        ENTITY_ACCESSOR_CACHE.put(key, (EntityDataAccessor<Object>)accessor);
        return accessor;
    }

    @Override
    public Object createPacket() {
        ArrayList<SynchedEntityData.DataValue> dataValues = new ArrayList<SynchedEntityData.DataValue>();
        for (FS_ClientboundSetEntityDataPacket.EntityData data : this.entityData) {
            try {
                Object typeKey;
                Optional optHolder;
                Holder.Reference holder;
                Registry registry;
                DedicatedServer server;
                Identifier loc;
                Object variantKey;
                Object e2;
                String s2;
                Object c;
                String originalFieldName = data.getAccessor().accessorFieldName();
                String accessorFieldName = ClientboundSetEntityDataPacketImpl.translateFieldName(data.getAccessor().entityClassName(), originalFieldName);
                String entityClassName = ClientboundSetEntityDataPacketImpl.translateClassName(data.getAccessor().entityClassName(), originalFieldName);
                EntityDataAccessor<Object> accessor = ClientboundSetEntityDataPacketImpl.getAccessorCached(entityClassName, accessorFieldName);
                Object vanillaValue = data.getValue();
                if (data.getValue() == null) continue;
                Object object = data.getValue();
                if (object instanceof Component) {
                    Component c2 = (Component)object;
                    vanillaValue = PaperAdventure.asVanilla((Component)c2);
                }
                if ((object = data.getValue()) instanceof Optional) {
                    Object t2;
                    Optional opt = (Optional)object;
                    if (opt.isPresent() && (t2 = opt.get()) instanceof Component) {
                        c = (Component)t2;
                        vanillaValue = Optional.of(PaperAdventure.asVanilla((Component)c));
                    } else {
                        vanillaValue = Optional.empty();
                    }
                }
                if ((c = data.getValue()) instanceof ItemStack) {
                    ItemStack i = (ItemStack)c;
                    vanillaValue = net.minecraft.world.item.ItemStack.fromBukkitCopy((ItemStack)i);
                }
                if ((c = data.getValue()) instanceof BlockState) {
                    BlockState b = (BlockState)c;
                    vanillaValue = ((CraftBlockState)b).getHandle();
                }
                if ((c = data.getValue()) instanceof String) {
                    s2 = (String)c;
                    if (accessorFieldName.equals("DATA_STATE") && entityClassName.contains("Armadillo")) {
                        try {
                            vanillaValue = Armadillo.ArmadilloState.valueOf((String)s2.toUpperCase());
                        }
                        catch (IllegalArgumentException e2) {
                            vanillaValue = Armadillo.ArmadilloState.IDLE;
                        }
                    }
                }
                if ((e2 = data.getValue()) instanceof String) {
                    s2 = (String)e2;
                    if (accessorFieldName.equals("DATA_VARIANT_ID") && entityClassName.contains("Wolf")) {
                        variantKey = s2.startsWith("wolf:") ? s2.substring("wolf:".length()) : s2;
                        loc = Identifier.parse((String)variantKey);
                        server = ((CraftServer)Bukkit.getServer()).getServer();
                        registry = server.registryAccess().lookupOrThrow(Registries.WOLF_VARIANT);
                        holder = registry.get(loc).orElse(null);
                        if (holder != null) {
                            vanillaValue = holder;
                        }
                    }
                }
                if ((variantKey = data.getValue()) instanceof String) {
                    s2 = (String)variantKey;
                    if (accessorFieldName.equals("DATA_VARIANT_ID") && entityClassName.contains("Cat")) {
                        variantKey = s2.startsWith("cat:") ? s2.substring("cat:".length()) : s2;
                        loc = Identifier.parse((String)variantKey);
                        server = ((CraftServer)Bukkit.getServer()).getServer();
                        registry = server.registryAccess().lookupOrThrow(Registries.CAT_VARIANT);
                        optHolder = registry.get(loc);
                        if (optHolder.isPresent()) {
                            vanillaValue = optHolder.get();
                        }
                    }
                }
                if ((variantKey = data.getValue()) instanceof String) {
                    s2 = (String)variantKey;
                    if (accessorFieldName.equals("DATA_VARIANT_ID") && entityClassName.contains("Frog")) {
                        variantKey = s2.startsWith("frog:") ? s2.substring("frog:".length()) : s2;
                        loc = Identifier.parse((String)variantKey);
                        server = ((CraftServer)Bukkit.getServer()).getServer();
                        registry = server.registryAccess().lookupOrThrow(Registries.FROG_VARIANT);
                        holder = registry.get(loc).orElse(null);
                        if (holder != null) {
                            vanillaValue = holder;
                        }
                    }
                }
                if ((variantKey = data.getValue()) instanceof String) {
                    s2 = (String)variantKey;
                    if (accessorFieldName.equals("DATA_VARIANT_ID") && entityClassName.contains("Cow") && !entityClassName.contains("Mushroom")) {
                        variantKey = s2.startsWith("minecraft:") ? s2 : "minecraft:" + s2.toLowerCase();
                        loc = Identifier.parse((String)variantKey);
                        server = ((CraftServer)Bukkit.getServer()).getServer();
                        registry = server.registryAccess().lookupOrThrow(Registries.COW_VARIANT);
                        optHolder = registry.get(loc);
                        if (optHolder.isPresent()) {
                            vanillaValue = optHolder.get();
                        }
                    }
                }
                if ((variantKey = data.getValue()) instanceof String) {
                    s2 = (String)variantKey;
                    if (accessorFieldName.equals("DATA_VARIANT_ID") && entityClassName.contains("Chicken")) {
                        variantKey = s2.startsWith("minecraft:") ? s2 : "minecraft:" + s2.toLowerCase();
                        loc = Identifier.parse((String)variantKey);
                        server = ((CraftServer)Bukkit.getServer()).getServer();
                        registry = server.registryAccess().lookupOrThrow(Registries.CHICKEN_VARIANT);
                        optHolder = registry.get(loc);
                        if (optHolder.isPresent()) {
                            vanillaValue = optHolder.get();
                        }
                    }
                }
                if ((variantKey = data.getValue()) instanceof String) {
                    s2 = (String)variantKey;
                    if (accessorFieldName.equals("DATA_VARIANT_ID") && entityClassName.contains("Pig") && !entityClassName.contains("Piglin")) {
                        variantKey = s2.startsWith("minecraft:") ? s2 : "minecraft:" + s2.toLowerCase();
                        loc = Identifier.parse((String)variantKey);
                        server = ((CraftServer)Bukkit.getServer()).getServer();
                        registry = server.registryAccess().lookupOrThrow(Registries.PIG_VARIANT);
                        optHolder = registry.get(loc);
                        if (optHolder.isPresent()) {
                            vanillaValue = optHolder.get();
                        }
                    }
                }
                if ((variantKey = data.getValue()) instanceof String) {
                    s2 = (String)variantKey;
                    if (accessorFieldName.equals("DATA_STATE") && entityClassName.contains("Sniffer")) {
                        try {
                            vanillaValue = Sniffer.State.valueOf((String)s2.toUpperCase());
                        }
                        catch (IllegalArgumentException e3) {
                            vanillaValue = Sniffer.State.IDLING;
                        }
                    }
                }
                if ((e2 = data.getValue()) instanceof String) {
                    s2 = (String)e2;
                    if (accessorFieldName.equals("DATA_TYPE") && entityClassName.contains("MushroomCow")) {
                        try {
                            vanillaValue = MushroomCow.Variant.valueOf((String)s2.toUpperCase());
                        }
                        catch (IllegalArgumentException e4) {
                            vanillaValue = MushroomCow.Variant.RED;
                        }
                    }
                }
                if ((e2 = data.getValue()) instanceof String) {
                    s2 = (String)e2;
                    if (accessorFieldName.equals("DATA_VILLAGER_DATA") && entityClassName.contains("Villager")) {
                        typeKey = "minecraft:plains";
                        String profKey = "minecraft:none";
                        int level = 1;
                        for (String part : s2.split(",")) {
                            if ((part = part.trim()).startsWith("type:")) {
                                typeKey = part.substring("type:".length());
                                continue;
                            }
                            if (part.startsWith("profession:")) {
                                profKey = part.substring("profession:".length());
                                continue;
                            }
                            if (!part.startsWith("level:")) continue;
                            try {
                                level = Integer.parseInt(part.substring("level:".length()));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        Identifier typeLoc = Identifier.parse((String)typeKey);
                        Identifier profLoc = Identifier.parse((String)profKey);
                        Holder.Reference typeHolder = BuiltInRegistries.VILLAGER_TYPE.get(typeLoc).orElse(null);
                        Holder.Reference profHolder = BuiltInRegistries.VILLAGER_PROFESSION.get(profLoc).orElse(null);
                        if (typeHolder != null && profHolder != null) {
                            vanillaValue = new VillagerData((Holder)typeHolder, (Holder)profHolder, level);
                        }
                    }
                }
                if ((typeKey = data.getValue()) instanceof FS_GameProfile) {
                    FS_GameProfile profile = (FS_GameProfile)typeKey;
                    if (accessorFieldName.equals("DATA_PROFILE")) {
                        GameProfile authProfile = GameProfileImpl.asVanilla(profile);
                        if (profile.hasTextureAssets()) {
                            Optional<Object> bodyTexture = Optional.empty();
                            Optional<Object> capeTexture = Optional.empty();
                            Optional<Object> elytraTexture = Optional.empty();
                            Optional<Object> modelType = Optional.empty();
                            if (profile.getSkinTextureAsset() != null) {
                                bodyTexture = Optional.of(new ClientAsset.ResourceTexture(Identifier.parse((String)profile.getSkinTextureAsset())));
                            }
                            if (profile.getCapeTextureAsset() != null) {
                                capeTexture = Optional.of(new ClientAsset.ResourceTexture(Identifier.parse((String)profile.getCapeTextureAsset())));
                            }
                            if (profile.getElytraTextureAsset() != null) {
                                elytraTexture = Optional.of(new ClientAsset.ResourceTexture(Identifier.parse((String)profile.getElytraTextureAsset())));
                            }
                            if (profile.getModelType() != null) {
                                modelType = Optional.of("SLIM".equalsIgnoreCase(profile.getModelType()) ? PlayerModelType.SLIM : PlayerModelType.WIDE);
                            }
                            PlayerSkin.Patch skinPatch = PlayerSkin.Patch.create(bodyTexture, capeTexture, elytraTexture, modelType);
                            vanillaValue = new ResolvableProfile.Static(Either.left((Object)authProfile), skinPatch);
                        } else {
                            vanillaValue = ResolvableProfile.createResolved((GameProfile)authProfile);
                        }
                    }
                }
                if ((object = data.getValue()) instanceof String) {
                    s2 = (String)object;
                    if (accessorFieldName.equals("DATA_PLAYER_MAIN_HAND")) {
                        HumanoidArm humanoidArm = vanillaValue = s2.equalsIgnoreCase("LEFT") ? HumanoidArm.LEFT : HumanoidArm.RIGHT;
                    }
                }
                if ((object = data.getValue()) instanceof String) {
                    s2 = (String)object;
                    if (accessorFieldName.equals("DATA_POSE")) {
                        vanillaValue = switch (s2.toUpperCase()) {
                            case "STANDING" -> Pose.STANDING;
                            case "FALL_FLYING" -> Pose.FALL_FLYING;
                            case "SLEEPING" -> Pose.SLEEPING;
                            case "SWIMMING" -> Pose.SWIMMING;
                            case "SPIN_ATTACK" -> Pose.SPIN_ATTACK;
                            case "CROUCHING", "SNEAKING" -> Pose.CROUCHING;
                            case "LONG_JUMPING" -> Pose.LONG_JUMPING;
                            case "DYING" -> Pose.DYING;
                            case "CROAKING" -> Pose.CROAKING;
                            case "USING_TONGUE" -> Pose.USING_TONGUE;
                            case "SITTING" -> Pose.SITTING;
                            case "ROARING" -> Pose.ROARING;
                            case "SNIFFING" -> Pose.SNIFFING;
                            case "EMERGING" -> Pose.EMERGING;
                            case "DIGGING" -> Pose.DIGGING;
                            case "SLIDING" -> Pose.SLIDING;
                            case "SHOOTING" -> Pose.SHOOTING;
                            case "INHALING" -> Pose.INHALING;
                            default -> Pose.STANDING;
                        };
                    }
                }
                dataValues.add(SynchedEntityData.DataValue.create(accessor, (Object)vanillaValue));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return new ClientboundSetEntityDataPacket(this.entityId, dataValues);
    }

    @Override
    public void sendPacketTo(FS_RealPlayer player) {
        ClientboundSetEntityDataPacket packet = (ClientboundSetEntityDataPacket)this.createPacket();
        ServerPlayer vanillaPlayer = VanillaPlayerAdapter.asVanilla(player.getBukkitPlayer());
        vanillaPlayer.connection.send((Packet)packet);
    }

    static {
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.Entity", Entity.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.LivingEntity", LivingEntity.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.Mob", Mob.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.AgeableMob", AgeableMob.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.Interaction", Interaction.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.player.Player", Player.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.decoration.ArmorStand", ArmorStand.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.Display", Display.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.Display$TextDisplay", Display.TextDisplay.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.Display$BlockDisplay", Display.BlockDisplay.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.Display$ItemDisplay", Display.ItemDisplay.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.Cow", Cow.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.Chicken", Chicken.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.Pig", Pig.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.MushroomCow", MushroomCow.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.Cat", Cat.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.Bee", Bee.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.Fox", Fox.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.Panda", Panda.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.Parrot", Parrot.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.PolarBear", PolarBear.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.Rabbit", Rabbit.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.Sheep", Sheep.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.Turtle", Turtle.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.cow.Cow", Cow.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.cow.MushroomCow", MushroomCow.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.chicken.Chicken", Chicken.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.pig.Pig", Pig.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.feline.Cat", Cat.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.bee.Bee", Bee.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.fox.Fox", Fox.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.panda.Panda", Panda.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.parrot.Parrot", Parrot.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.rabbit.Rabbit", Rabbit.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.sheep.Sheep", Sheep.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.fish.TropicalFish", TropicalFish.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.equine.Llama", Llama.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.equine.Horse", Horse.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.frog.Frog", Frog.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.wolf.Wolf", Wolf.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.armadillo.Armadillo", Armadillo.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.sniffer.Sniffer", Sniffer.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.axolotl.Axolotl", Axolotl.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.camel.Camel", Camel.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.animal.goat.Goat", Goat.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.monster.SpellcasterIllager", SpellcasterIllager.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.monster.Creeper", Creeper.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.raid.Raider", Raider.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.npc.Villager", Villager.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.Avatar", Avatar.class);
        ENTITY_CLASS_CACHE.put("net.minecraft.world.entity.decoration.Mannequin", Mannequin.class);
    }
}

