/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.commands.npc;

import de.oliver.cloud.annotations.Command;
import de.oliver.cloud.annotations.Flag;
import de.oliver.cloud.annotations.Permission;
import de.oliver.fancylib.translations.Translator;
import de.oliver.fancynpcs.FancyNpcs;
import de.oliver.fancynpcs.api.Npc;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum NearbyCMD {
    INSTANCE;

    private final Translator translator = FancyNpcs.getInstance().getTranslator();
    private static final DecimalFormat COORDS_FORMAT;
    private static final DecimalFormat DISTANCE_FORMAT;

    @Command(value="npc nearby", requiredSender=Player.class)
    @Permission(value={"fancynpcs.command.npc.nearby"})
    public void onCommand(@NotNull Player sender, @Flag(value="radius") @Nullable Long radius, @Flag(value="type") @Nullable EntityType type, @Flag(value="sort") @Nullable SortType sort) {
        Stream<Object> stream = FancyNpcs.getInstance().getNpcManagerImpl().getAllNpcs().stream();
        Location senderLocation = sender.getLocation();
        AtomicInteger totalCount = new AtomicInteger(0);
        stream = stream.filter(npc -> {
            if (npc.getData().getLocation().getWorld().equals((Object)senderLocation.getWorld())) {
                totalCount.incrementAndGet();
                return true;
            }
            return false;
        });
        if (FancyNpcs.PLAYER_NPCS_FEATURE_FLAG.isEnabled()) {
            stream = stream.filter(npc -> npc.getData().getCreator().equals(sender.getUniqueId()));
        }
        if (radius != null) {
            stream = stream.filter(npc -> npc.getData().getLocation().distance(senderLocation) <= (double)radius.longValue());
        }
        if (type != null) {
            stream = stream.filter(npc -> npc.getData().getType() == type);
        }
        switch ((sort != null ? sort : SortType.NEAREST).ordinal()) {
            case 0: {
                stream = stream.sorted(Comparator.comparing(npc -> npc.getData().getName()));
                break;
            }
            case 1: {
                stream = stream.sorted(Comparator.comparing(npc -> ((Npc)npc).getData().getName()).reversed());
                break;
            }
            case 2: {
                stream = stream.sorted(Comparator.comparingDouble(npc -> npc.getData().getLocation().distance(senderLocation)));
                break;
            }
            case 3: {
                stream = stream.sorted(Comparator.comparingDouble(npc -> ((Npc)npc).getData().getLocation().distance(senderLocation)).reversed());
            }
        }
        this.translator.translate("npc_nearby_header").send((CommandSender)sender);
        AtomicInteger count = new AtomicInteger(0);
        stream.forEachOrdered(npc -> this.translator.translate("npc_nearby_entry").replace("number", String.valueOf(count.incrementAndGet())).replace("npc", npc.getData().getName()).replace("distance", DISTANCE_FORMAT.format(npc.getData().getLocation().distance(senderLocation))).replace("location_x", COORDS_FORMAT.format(npc.getData().getLocation().x())).replace("location_y", COORDS_FORMAT.format(npc.getData().getLocation().y())).replace("location_z", COORDS_FORMAT.format(npc.getData().getLocation().z())).replace("world", npc.getData().getLocation().getWorld().getName()).send((CommandSender)sender));
        this.translator.translate("npc_nearby_footer").replace("count", String.valueOf(count)).replace("count_formatted", "\u00b7 ".repeat(3 - String.valueOf(count).length()) + String.valueOf(count)).replace("total", String.valueOf(totalCount)).replace("total_formatted", "\u00b7 ".repeat(3 - String.valueOf(totalCount).length()) + String.valueOf(totalCount)).send((CommandSender)sender);
    }

    static {
        COORDS_FORMAT = new DecimalFormat("#.##");
        DISTANCE_FORMAT = new DecimalFormat("#.#");
        COORDS_FORMAT.setMinimumFractionDigits(2);
    }

    public static enum SortType {
        NAME,
        NAME_REVERSED,
        NEAREST,
        FARTHEST;

    }
}

