/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.commands;

import de.oliver.cloud.annotations.Command;
import de.oliver.cloud.annotations.Permission;
import de.oliver.fancyanalytics.logger.properties.Property;
import de.oliver.fancylib.translations.Translator;
import de.oliver.fancynpcs.FancyNpcs;
import de.oliver.fancynpcs.skins.mineskin.MineSkinQueue;
import de.oliver.fancynpcs.skins.mojang.MojangQueue;
import de.oliver.fancynpcs.tests.FancyNpcsTests;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class FancyNpcsDebugCMD {
    public static final FancyNpcsDebugCMD INSTANCE = new FancyNpcsDebugCMD();
    private final Translator translator = FancyNpcs.getInstance().getTranslator();
    private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    private FancyNpcsDebugCMD() {
    }

    @Command(value="fancynpcs run_tests")
    @Permission(value={"fancynpcs.command.fancynpcs.run_tests"})
    public void onTest(Player player) {
        FancyNpcsTests tests = new FancyNpcsTests();
        boolean tested = tests.runAllTests(player);
        if (tested) {
            this.translator.translate("fancynpcs_test_success").replace("player", player.getName()).replace("time", this.dateTimeFormatter.format(new Date().toInstant().atZone(ZoneId.of("Europe/Berlin")))).replace("count", String.valueOf(tests.getTestCount())).send((CommandSender)player);
        } else {
            this.translator.translate("fancynpcs_test_failure").replace("player", player.getName()).replace("time", this.dateTimeFormatter.format(new Date().toInstant().atZone(ZoneId.of("Europe/Berlin")))).send((CommandSender)player);
        }
    }

    @Command(value="fancynpcs skin_system restart_schedulers")
    @Permission(value={"fancynpcs.command.fancynpcs.skin_system.restart_schedulers"})
    public void onSkinSchedulerRestart(Player player) {
        MineSkinQueue.get().getScheduler().cancel(true);
        MojangQueue.get().getScheduler().cancel(true);
        MineSkinQueue.get().run();
        MojangQueue.get().run();
        this.translator.translate("fancynpcs_skin_system_restart_schedulers_success").send((CommandSender)player);
    }

    @Command(value="fancynpcs skin_system scheduler_status")
    @Permission(value={"fancynpcs.command.fancynpcs.skin_system.scheduler_status"})
    public void onSkinSchedulerStatus(Player player) {
        String mineSkinStatus = MineSkinQueue.get().getScheduler().toString();
        FancyNpcs.getInstance().getFancyLogger().info("MineSkinAPI Status: " + mineSkinStatus, new Property[0]);
        this.translator.translate("fancynpcs_skin_system_scheduler_status").replace("scheduler", "MineSkinAPI").replace("status", mineSkinStatus).send((CommandSender)player);
        String mojangStatus = MojangQueue.get().getScheduler().toString();
        FancyNpcs.getInstance().getFancyLogger().info("MojangAPI Status: " + mojangStatus, new Property[0]);
        this.translator.translate("fancynpcs_skin_system_scheduler_status").replace("scheduler", "MojangAPI").replace("status", mojangStatus).send((CommandSender)player);
    }

    @Command(value="fancynpcs skin_system clear_queues")
    @Permission(value={"fancynpcs.command.fancynpcs.skin_system.clear_queues"})
    public void onClearSkinQueues(Player player) {
        MineSkinQueue.get().clear();
        MojangQueue.get().clear();
        this.translator.translate("fancynpcs_skin_system_clear_queues_success").send((CommandSender)player);
    }

    @Command(value="fancynpcs skin_system clear_cache")
    @Permission(value={"fancynpcs.command.fancynpcs.skin_system.clear_cache"})
    public void onInvalidateCache(Player player) {
        FancyNpcs.getInstance().getSkinManagerImpl().getMemCache().clear();
        FancyNpcs.getInstance().getSkinManagerImpl().getFileCache().clear();
        this.translator.translate("fancynpcs_skin_system_clear_cache_success").send((CommandSender)player);
    }

    @Command(value="fancynpcs skin_system clear_uuid_cache")
    @Permission(value={"fancynpcs.command.fancynpcs.skin_system.clear_uuid_cache"})
    public void onInvalidateUUidCache(Player player) {
        FancyNpcs.getInstance().getSkinManagerImpl().getUuidCache().clearCache();
        this.translator.translate("fancynpcs_skin_system_clear_uuid_cache_success").send((CommandSender)player);
    }
}

