/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancysitula.versions.v1_21_9.packets;

import de.oliver.fancysitula.api.entities.FS_RealPlayer;
import de.oliver.fancysitula.api.packets.FS_ClientboundSetEntityDataPacket;
import de.oliver.fancysitula.api.utils.reflections.ReflectionUtils;
import de.oliver.fancysitula.versions.v1_21_9.utils.VanillaPlayerAdapter;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.kyori.adventure.text.Component;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.npc.VillagerData;
import org.bukkit.Bukkit;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.inventory.ItemStack;

public class ClientboundSetEntityDataPacketImpl
extends FS_ClientboundSetEntityDataPacket {
    private static final ConcurrentMap<String, Class<?>> ENTITY_CLASS_CACHE = new ConcurrentHashMap();
    private static final ConcurrentMap<String, EntityDataAccessor<Object>> ENTITY_ACCESSOR_CACHE = new ConcurrentHashMap<String, EntityDataAccessor<Object>>();

    public ClientboundSetEntityDataPacketImpl(int entityId, List<FS_ClientboundSetEntityDataPacket.EntityData> entityData) {
        super(entityId, entityData);
    }

    private static Class<?> getEntityClassCached(String className) throws ClassNotFoundException {
        Class cached = (Class)ENTITY_CLASS_CACHE.get(className);
        if (cached != null) {
            return cached;
        }
        ClassLoader classLoader = MinecraftServer.class.getClassLoader();
        Class<?> resolved = classLoader.loadClass(className);
        ENTITY_CLASS_CACHE.put(className, resolved);
        return resolved;
    }

    private static EntityDataAccessor<Object> getAccessorCached(String entityClassName, String fieldName) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        String key = entityClassName + "#" + fieldName;
        EntityDataAccessor cached = (EntityDataAccessor)ENTITY_ACCESSOR_CACHE.get(key);
        if (cached != null) {
            return cached;
        }
        Class<?> entityClass = ClientboundSetEntityDataPacketImpl.getEntityClassCached(entityClassName);
        EntityDataAccessor accessor = (EntityDataAccessor)ReflectionUtils.getStaticField(entityClass, fieldName);
        ENTITY_ACCESSOR_CACHE.put(key, (EntityDataAccessor<Object>)accessor);
        return accessor;
    }

    @Override
    public Object createPacket() {
        ArrayList<SynchedEntityData.DataValue> dataValues = new ArrayList<SynchedEntityData.DataValue>();
        for (FS_ClientboundSetEntityDataPacket.EntityData data : this.entityData) {
            try {
                Holder.Reference holder;
                Registry registry;
                DedicatedServer server;
                ResourceLocation loc;
                Object variantKey;
                Object e2;
                String s2;
                Object b;
                Object c;
                String entityClassName = data.getAccessor().entityClassName();
                String accessorFieldName = data.getAccessor().accessorFieldName();
                EntityDataAccessor<Object> accessor = ClientboundSetEntityDataPacketImpl.getAccessorCached(entityClassName, accessorFieldName);
                Object vanillaValue = data.getValue();
                if (data.getValue() == null) continue;
                Object object = data.getValue();
                if (object instanceof Component) {
                    Component c2 = (Component)object;
                    vanillaValue = PaperAdventure.asVanilla((Component)c2);
                }
                if ((object = data.getValue()) instanceof Optional) {
                    Object t2;
                    Optional opt = (Optional)object;
                    if (opt.isPresent() && (t2 = opt.get()) instanceof Component) {
                        c = (Component)t2;
                        vanillaValue = Optional.of(PaperAdventure.asVanilla((Component)c));
                    } else {
                        vanillaValue = Optional.empty();
                    }
                }
                if ((c = data.getValue()) instanceof ItemStack) {
                    ItemStack i = (ItemStack)c;
                    vanillaValue = net.minecraft.world.item.ItemStack.fromBukkitCopy((ItemStack)i);
                }
                if ((c = data.getValue()) instanceof BlockState) {
                    b = (BlockState)c;
                    vanillaValue = ((CraftBlockState)b).getHandle();
                }
                if ((c = data.getValue()) instanceof String) {
                    s2 = (String)c;
                    if (accessorFieldName.equals("DATA_STATE") && entityClassName.contains("Armadillo")) {
                        try {
                            vanillaValue = Armadillo.ArmadilloState.valueOf((String)s2.toUpperCase());
                        }
                        catch (IllegalArgumentException e2) {
                            vanillaValue = Armadillo.ArmadilloState.IDLE;
                        }
                    }
                }
                if ((e2 = data.getValue()) instanceof String) {
                    s2 = (String)e2;
                    if (accessorFieldName.equals("DATA_VARIANT_ID") && entityClassName.contains("Wolf")) {
                        variantKey = s2.startsWith("wolf:") ? s2.substring("wolf:".length()) : s2;
                        loc = ResourceLocation.parse((String)variantKey);
                        server = ((CraftServer)Bukkit.getServer()).getServer();
                        registry = server.registryAccess().lookupOrThrow(Registries.WOLF_VARIANT);
                        holder = registry.get(loc).orElse(null);
                        if (holder != null) {
                            vanillaValue = holder;
                        }
                    }
                }
                if ((variantKey = data.getValue()) instanceof String) {
                    s2 = (String)variantKey;
                    if (accessorFieldName.equals("DATA_VARIANT_ID") && entityClassName.contains("Cat")) {
                        variantKey = s2.startsWith("cat:") ? s2.substring("cat:".length()) : s2;
                        loc = ResourceLocation.parse((String)variantKey);
                        server = ((CraftServer)Bukkit.getServer()).getServer();
                        registry = server.registryAccess().lookupOrThrow(Registries.CAT_VARIANT);
                        holder = registry.get(loc).orElse(null);
                        if (holder != null) {
                            vanillaValue = holder;
                        }
                    }
                }
                if ((variantKey = data.getValue()) instanceof String) {
                    s2 = (String)variantKey;
                    if (accessorFieldName.equals("DATA_VARIANT_ID") && entityClassName.contains("Frog")) {
                        variantKey = s2.startsWith("frog:") ? s2.substring("frog:".length()) : s2;
                        loc = ResourceLocation.parse((String)variantKey);
                        server = ((CraftServer)Bukkit.getServer()).getServer();
                        registry = server.registryAccess().lookupOrThrow(Registries.FROG_VARIANT);
                        holder = registry.get(loc).orElse(null);
                        if (holder != null) {
                            vanillaValue = holder;
                        }
                    }
                }
                if ((variantKey = data.getValue()) instanceof String) {
                    s2 = (String)variantKey;
                    if (accessorFieldName.equals("DATA_VARIANT_ID") && entityClassName.contains("Cow") && !entityClassName.contains("Mushroom")) {
                        variantKey = s2.startsWith("minecraft:") ? s2 : "minecraft:" + s2.toLowerCase();
                        loc = ResourceLocation.parse((String)variantKey);
                        server = ((CraftServer)Bukkit.getServer()).getServer();
                        registry = server.registryAccess().lookupOrThrow(Registries.COW_VARIANT);
                        holder = registry.get(loc).orElse(null);
                        if (holder != null) {
                            vanillaValue = holder;
                        }
                    }
                }
                if ((variantKey = data.getValue()) instanceof String) {
                    s2 = (String)variantKey;
                    if (accessorFieldName.equals("DATA_VARIANT_ID") && entityClassName.contains("Chicken")) {
                        variantKey = s2.startsWith("minecraft:") ? s2 : "minecraft:" + s2.toLowerCase();
                        loc = ResourceLocation.parse((String)variantKey);
                        server = ((CraftServer)Bukkit.getServer()).getServer();
                        registry = server.registryAccess().lookupOrThrow(Registries.CHICKEN_VARIANT);
                        holder = registry.get(loc).orElse(null);
                        if (holder != null) {
                            vanillaValue = holder;
                        }
                    }
                }
                if ((variantKey = data.getValue()) instanceof String) {
                    s2 = (String)variantKey;
                    if (accessorFieldName.equals("DATA_VARIANT_ID") && entityClassName.contains("Pig") && !entityClassName.contains("Piglin")) {
                        variantKey = s2.startsWith("minecraft:") ? s2 : "minecraft:" + s2.toLowerCase();
                        loc = ResourceLocation.parse((String)variantKey);
                        server = ((CraftServer)Bukkit.getServer()).getServer();
                        registry = server.registryAccess().lookupOrThrow(Registries.PIG_VARIANT);
                        holder = registry.get(loc).orElse(null);
                        if (holder != null) {
                            vanillaValue = holder;
                        }
                    }
                }
                if ((variantKey = data.getValue()) instanceof String) {
                    s2 = (String)variantKey;
                    if (accessorFieldName.equals("DATA_STATE") && entityClassName.contains("Sniffer")) {
                        try {
                            vanillaValue = Sniffer.State.valueOf((String)s2.toUpperCase());
                        }
                        catch (IllegalArgumentException e3) {
                            vanillaValue = Sniffer.State.IDLING;
                        }
                    }
                }
                if ((e2 = data.getValue()) instanceof String) {
                    s2 = (String)e2;
                    if (accessorFieldName.equals("DATA_TYPE") && entityClassName.contains("MushroomCow")) {
                        try {
                            vanillaValue = MushroomCow.Variant.valueOf((String)s2.toUpperCase());
                        }
                        catch (IllegalArgumentException e4) {
                            vanillaValue = MushroomCow.Variant.RED;
                        }
                    }
                }
                if ((e2 = data.getValue()) instanceof Byte) {
                    b = (Byte)e2;
                    if (accessorFieldName.equals("DATA_SPELL_CASTING_ID") && entityClassName.contains("SpellcasterIllager")) {
                        vanillaValue = b;
                    }
                }
                if ((e2 = data.getValue()) instanceof String) {
                    s2 = (String)e2;
                    if (accessorFieldName.equals("DATA_VILLAGER_DATA") && entityClassName.contains("Villager")) {
                        String typeKey = "minecraft:plains";
                        String profKey = "minecraft:none";
                        int level = 1;
                        for (String part : s2.split(",")) {
                            if ((part = part.trim()).startsWith("type:")) {
                                typeKey = part.substring("type:".length());
                                continue;
                            }
                            if (part.startsWith("profession:")) {
                                profKey = part.substring("profession:".length());
                                continue;
                            }
                            if (!part.startsWith("level:")) continue;
                            try {
                                level = Integer.parseInt(part.substring("level:".length()));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        ResourceLocation typeLoc = ResourceLocation.parse((String)typeKey);
                        ResourceLocation profLoc = ResourceLocation.parse((String)profKey);
                        Holder.Reference typeHolder = BuiltInRegistries.VILLAGER_TYPE.get(typeLoc).orElse(null);
                        Holder.Reference profHolder = BuiltInRegistries.VILLAGER_PROFESSION.get(profLoc).orElse(null);
                        if (typeHolder != null && profHolder != null) {
                            vanillaValue = new VillagerData((Holder)typeHolder, (Holder)profHolder, level);
                        }
                    }
                }
                dataValues.add(SynchedEntityData.DataValue.create(accessor, (Object)vanillaValue));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return new ClientboundSetEntityDataPacket(this.entityId, dataValues);
    }

    @Override
    public void sendPacketTo(FS_RealPlayer player) {
        ClientboundSetEntityDataPacket packet = (ClientboundSetEntityDataPacket)this.createPacket();
        ServerPlayer vanillaPlayer = VanillaPlayerAdapter.asVanilla(player.getBukkitPlayer());
        vanillaPlayer.connection.send((Packet)packet);
    }
}

