/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.v1_21_9.attributes;

import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcAttribute;
import de.oliver.fancynpcs.v1_21_9.ReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.ChickenVariant;
import org.bukkit.entity.EntityType;

public class ChickenAttributes {
    public static List<NpcAttribute> getAllAttributes() {
        ArrayList<NpcAttribute> attributes = new ArrayList<NpcAttribute>();
        attributes.add(new NpcAttribute("variant", ChickenAttributes.getChickenVariantRegistry().listElementIds().map(id -> id.location().getPath()).toList(), List.of(EntityType.CHICKEN), ChickenAttributes::setVariant));
        return attributes;
    }

    private static void setVariant(Npc npc, String value) {
        Chicken cow = (Chicken)ReflectionHelper.getEntity(npc);
        Holder variant = (Holder)ChickenAttributes.getChickenVariantRegistry().get(ResourceKey.create((ResourceKey)Registries.CHICKEN_VARIANT, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)value.toLowerCase()))).orElseThrow();
        cow.setVariant(variant);
    }

    private static HolderLookup.RegistryLookup<ChickenVariant> getChickenVariantRegistry() {
        return MinecraftServer.getServer().registryAccess().lookupOrThrow(Registries.CHICKEN_VARIANT);
    }
}

