/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.v1_21_6.attributes;

import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcAttribute;
import de.oliver.fancynpcs.v1_21_6.ReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.Villager;
import org.bukkit.entity.EntityType;

public class VillagerAttributes {
    public static List<NpcAttribute> getAllAttributes() {
        ArrayList<NpcAttribute> attributes = new ArrayList<NpcAttribute>();
        attributes.add(new NpcAttribute("profession", BuiltInRegistries.VILLAGER_PROFESSION.keySet().stream().map(ResourceLocation::getPath).toList(), List.of(EntityType.VILLAGER), VillagerAttributes::setProfession));
        attributes.add(new NpcAttribute("type", BuiltInRegistries.VILLAGER_TYPE.keySet().stream().map(ResourceLocation::getPath).toList(), List.of(EntityType.VILLAGER), VillagerAttributes::setType));
        return attributes;
    }

    private static void setProfession(Npc npc, String value) {
        Villager villager = (Villager)ReflectionHelper.getEntity(npc);
        Holder profession = (Holder)BuiltInRegistries.VILLAGER_PROFESSION.get(ResourceLocation.tryParse((String)value)).orElseThrow();
        villager.setVillagerData(villager.getVillagerData().withProfession(profession));
    }

    private static void setType(Npc npc, String value) {
        Villager villager = (Villager)ReflectionHelper.getEntity(npc);
        Holder type = (Holder)BuiltInRegistries.VILLAGER_TYPE.get(ResourceLocation.tryParse((String)value)).orElseThrow();
        villager.setVillagerData(villager.getVillagerData().withType(type));
    }
}

