/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.v1_21_5;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import de.oliver.fancylib.ReflectionUtils;
import de.oliver.fancynpcs.api.FancyNpcsPlugin;
import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcAttribute;
import de.oliver.fancynpcs.api.NpcData;
import de.oliver.fancynpcs.api.events.NpcSpawnEvent;
import de.oliver.fancynpcs.api.utils.NpcEquipmentSlot;
import de.oliver.fancynpcs.libs.chatcolorhandler.ModernChatColorHandler;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.Optionull;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class Npc_1_21_5
extends Npc {
    private final String localName = this.generateLocalName();
    private final UUID uuid = UUID.randomUUID();
    private Entity npc;
    private Display.TextDisplay sittingVehicle;

    public Npc_1_21_5(NpcData data) {
        super(data);
    }

    @Override
    public void create() {
        DedicatedServer minecraftServer = ((CraftServer)Bukkit.getServer()).getServer();
        ServerLevel serverLevel = ((CraftWorld)this.data.getLocation().getWorld()).getHandle();
        GameProfile gameProfile = new GameProfile(this.uuid, this.localName);
        if (this.data.getType() == EntityType.PLAYER) {
            this.npc = new ServerPlayer((MinecraftServer)minecraftServer, serverLevel, new GameProfile(this.uuid, ""), ClientInformation.createDefault());
            ((ServerPlayer)this.npc).gameProfile = gameProfile;
        } else {
            Optional entityTypeReference = BuiltInRegistries.ENTITY_TYPE.get(CraftNamespacedKey.toMinecraft((NamespacedKey)this.data.getType().getKey()));
            net.minecraft.world.entity.EntityType nmsType = (net.minecraft.world.entity.EntityType)((Holder.Reference)entityTypeReference.get()).value();
            EntityType.EntityFactory factory = (EntityType.EntityFactory)ReflectionUtils.getValue(nmsType, "factory");
            this.npc = factory.create(nmsType, (Level)serverLevel);
            this.isTeamCreated.clear();
        }
    }

    @Override
    public void spawn(org.bukkit.entity.Player player) {
        ServerPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        if (this.npc == null) {
            return;
        }
        if (!this.data.getLocation().getWorld().getName().equalsIgnoreCase(serverPlayer.level().getWorld().getName())) {
            return;
        }
        if (this.data.getSkinData() != null && this.data.getSkinData().hasTexture()) {
            String value = this.data.getSkinData().getTextureValue();
            String signature = this.data.getSkinData().getTextureSignature();
            ((ServerPlayer)this.npc).getGameProfile().getProperties().replaceValues((Object)"textures", ImmutableList.of(new Property("textures", value, signature)));
        }
        if (!new NpcSpawnEvent(this, player).callEvent()) {
            return;
        }
        ArrayList<Object> packets = new ArrayList<Object>();
        Entity entity = this.npc;
        if (entity instanceof ServerPlayer) {
            ServerPlayer npcPlayer = (ServerPlayer)entity;
            EnumSet<ClientboundPlayerInfoUpdatePacket.Action> actions = EnumSet.noneOf(ClientboundPlayerInfoUpdatePacket.Action.class);
            actions.add(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER);
            actions.add(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME);
            if (this.data.isShowInTab()) {
                actions.add(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_LISTED);
            }
            ClientboundPlayerInfoUpdatePacket playerInfoPacket = new ClientboundPlayerInfoUpdatePacket(actions, this.getEntry(npcPlayer, serverPlayer));
            packets.add(playerInfoPacket);
            if (this.data.isSpawnEntity()) {
                this.npc.setPos(this.data.getLocation().x(), this.data.getLocation().y(), this.data.getLocation().z());
            }
        }
        ClientboundAddEntityPacket addEntityPacket = new ClientboundAddEntityPacket(this.npc.getId(), this.npc.getUUID(), this.data.getLocation().x(), this.data.getLocation().y(), this.data.getLocation().z(), this.data.getLocation().getPitch(), this.data.getLocation().getYaw(), this.npc.getType(), 0, Vec3.ZERO, (double)this.data.getLocation().getYaw());
        packets.add(addEntityPacket);
        this.isVisibleForPlayer.put(player.getUniqueId(), true);
        int removeNpcsFromPlayerlistDelay = FancyNpcsPlugin.get().getFancyNpcConfig().getRemoveNpcsFromPlayerlistDelay();
        if (!this.data.isShowInTab() && removeNpcsFromPlayerlistDelay > 0) {
            FancyNpcsPlugin.get().getNpcThread().schedule(() -> {
                ClientboundPlayerInfoRemovePacket playerInfoRemovePacket = new ClientboundPlayerInfoRemovePacket(List.of(this.npc.getUUID()));
                this.runOnPlayerScheduler((org.bukkit.entity.Player)serverPlayer.getBukkitEntity(), () -> serverPlayer.connection.send((Packet)playerInfoRemovePacket));
            }, (long)removeNpcsFromPlayerlistDelay, TimeUnit.MILLISECONDS);
        }
        ClientboundBundlePacket bundlePacket = new ClientboundBundlePacket(packets);
        this.runOnPlayerScheduler((org.bukkit.entity.Player)serverPlayer.getBukkitEntity(), () -> serverPlayer.connection.send((Packet)bundlePacket));
        this.update(player);
    }

    @Override
    public void remove(org.bukkit.entity.Player player) {
        if (this.npc == null) {
            return;
        }
        ServerPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        Entity entity = this.npc;
        if (entity instanceof ServerPlayer) {
            ServerPlayer npcPlayer = (ServerPlayer)entity;
            ClientboundPlayerInfoRemovePacket playerInfoRemovePacket = new ClientboundPlayerInfoRemovePacket(List.of(npcPlayer.getUUID()));
            this.runOnPlayerScheduler((org.bukkit.entity.Player)serverPlayer.getBukkitEntity(), () -> serverPlayer.connection.send((Packet)playerInfoRemovePacket));
        }
        ClientboundRemoveEntitiesPacket removeEntitiesPacket = new ClientboundRemoveEntitiesPacket(new int[]{this.npc.getId()});
        this.runOnPlayerScheduler((org.bukkit.entity.Player)serverPlayer.getBukkitEntity(), () -> serverPlayer.connection.send((Packet)removeEntitiesPacket));
        if (this.sittingVehicle != null) {
            ClientboundRemoveEntitiesPacket removeSittingVehiclePacket = new ClientboundRemoveEntitiesPacket(new int[]{this.sittingVehicle.getId()});
            this.runOnPlayerScheduler((org.bukkit.entity.Player)serverPlayer.getBukkitEntity(), () -> serverPlayer.connection.send((Packet)removeSittingVehiclePacket));
        }
        this.isVisibleForPlayer.put(serverPlayer.getUUID(), false);
    }

    @Override
    public void lookAt(org.bukkit.entity.Player player, Location location) {
        if (this.npc == null) {
            return;
        }
        ServerPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        this.npc.setRot(location.getYaw(), location.getPitch());
        this.npc.setYHeadRot(location.getYaw());
        this.npc.setXRot(location.getPitch());
        this.npc.setYRot(location.getYaw());
        ClientboundTeleportEntityPacket teleportEntityPacket = new ClientboundTeleportEntityPacket(this.npc.getId(), new PositionMoveRotation(new Vec3(this.data.getLocation().getX(), this.data.getLocation().getY(), this.data.getLocation().getZ()), Vec3.ZERO, location.getYaw(), location.getPitch()), Set.of(), false);
        this.runOnPlayerScheduler((org.bukkit.entity.Player)serverPlayer.getBukkitEntity(), () -> serverPlayer.connection.send((Packet)teleportEntityPacket));
        float angelMultiplier = 0.7111111f;
        ClientboundRotateHeadPacket rotateHeadPacket = new ClientboundRotateHeadPacket(this.npc, (byte)(location.getYaw() * angelMultiplier));
        this.runOnPlayerScheduler((org.bukkit.entity.Player)serverPlayer.getBukkitEntity(), () -> serverPlayer.connection.send((Packet)rotateHeadPacket));
    }

    @Override
    public void update(org.bukkit.entity.Player player, boolean swingArm) {
        String string;
        if (this.npc == null) {
            return;
        }
        if (!this.isVisibleForPlayer.getOrDefault(player.getUniqueId(), false).booleanValue()) {
            return;
        }
        ServerPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        PlayerTeam team = new PlayerTeam(new Scoreboard(), "npc-" + this.localName);
        team.getPlayers().clear();
        Collection collection = team.getPlayers();
        Entity entity = this.npc;
        if (entity instanceof ServerPlayer) {
            ServerPlayer npcPlayer = (ServerPlayer)entity;
            string = npcPlayer.getGameProfile().getName();
        } else {
            string = this.npc.getStringUUID();
        }
        collection.add(string);
        team.setColor(PaperAdventure.asVanilla((TextColor)this.data.getGlowingColor()));
        if (!this.data.isCollidable()) {
            team.setCollisionRule(Team.CollisionRule.NEVER);
        }
        Component displayName = ModernChatColorHandler.translate(this.data.getDisplayName(), (org.bukkit.entity.Player)serverPlayer.getBukkitEntity());
        net.minecraft.network.chat.Component vanillaComponent = PaperAdventure.asVanilla((Component)displayName);
        try {
            ComponentSerialization.CODEC.encodeStart((DynamicOps)JavaOps.INSTANCE, (Object)vanillaComponent);
        }
        catch (Exception e) {
            vanillaComponent = net.minecraft.network.chat.Component.literal((String)"Invalid displayname (check MiniMessage syntax)");
        }
        if (!(this.npc instanceof ServerPlayer)) {
            this.npc.setCustomName(vanillaComponent);
            this.npc.setCustomNameVisible(true);
        } else {
            this.npc.setCustomName(null);
            this.npc.setCustomNameVisible(false);
        }
        if (this.data.getDisplayName().equalsIgnoreCase("<empty>")) {
            team.setNameTagVisibility(Team.Visibility.NEVER);
            this.npc.setCustomName(null);
            this.npc.setCustomNameVisible(false);
        } else {
            team.setNameTagVisibility(Team.Visibility.ALWAYS);
        }
        Entity entity2 = this.npc;
        if (entity2 instanceof ServerPlayer) {
            ServerPlayer npcPlayer = (ServerPlayer)entity2;
            team.setPlayerPrefix(vanillaComponent);
            npcPlayer.listName = vanillaComponent;
            EnumSet<ClientboundPlayerInfoUpdatePacket.Action> actions = EnumSet.noneOf(ClientboundPlayerInfoUpdatePacket.Action.class);
            actions.add(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME);
            if (this.data.isShowInTab()) {
                actions.add(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_LISTED);
            }
            ClientboundPlayerInfoUpdatePacket playerInfoPacket = new ClientboundPlayerInfoUpdatePacket(actions, this.getEntry(npcPlayer, serverPlayer));
            this.runOnPlayerScheduler((org.bukkit.entity.Player)serverPlayer.getBukkitEntity(), () -> serverPlayer.connection.send((Packet)playerInfoPacket));
        }
        boolean isTeamCreatedForPlayer = this.isTeamCreated.getOrDefault(player.getUniqueId(), false);
        this.runOnPlayerScheduler((org.bukkit.entity.Player)serverPlayer.getBukkitEntity(), () -> serverPlayer.connection.send((Packet)ClientboundSetPlayerTeamPacket.createAddOrModifyPacket((PlayerTeam)team, (!isTeamCreatedForPlayer ? 1 : 0) != 0)));
        this.isTeamCreated.put(player.getUniqueId(), true);
        this.npc.setGlowingTag(this.data.isGlowing());
        if (this.data.getEquipment() != null && !this.data.getEquipment().isEmpty()) {
            ArrayList<Pair> equipmentList = new ArrayList<Pair>();
            for (NpcEquipmentSlot slot : this.data.getEquipment().keySet()) {
                equipmentList.add(new Pair((Object)EquipmentSlot.byName((String)slot.toNmsName()), (Object)CraftItemStack.asNMSCopy((ItemStack)this.data.getEquipment().get((Object)slot))));
            }
            ClientboundSetEquipmentPacket setEquipmentPacket = new ClientboundSetEquipmentPacket(this.npc.getId(), equipmentList);
            this.runOnPlayerScheduler((org.bukkit.entity.Player)serverPlayer.getBukkitEntity(), () -> serverPlayer.connection.send((Packet)setEquipmentPacket));
        }
        if (this.npc instanceof ServerPlayer) {
            this.npc.getEntityData().set(Player.DATA_PLAYER_MODE_CUSTOMISATION, (Object)127);
        }
        this.data.applyAllAttributes(this);
        this.refreshEntityData(player);
        if (this.data.isSpawnEntity() && this.data.getLocation() != null) {
            this.move(player, swingArm);
        }
        NpcAttribute playerPoseAttr = FancyNpcsPlugin.get().getAttributeManager().getAttributeByName(EntityType.PLAYER, "pose");
        if (this.data.getAttributes().containsKey(playerPoseAttr)) {
            String pose = this.data.getAttributes().get(playerPoseAttr);
            if (pose.equals("sitting")) {
                this.setSitting(serverPlayer);
            } else if (this.sittingVehicle != null) {
                ClientboundRemoveEntitiesPacket removeSittingVehiclePacket = new ClientboundRemoveEntitiesPacket(new int[]{this.sittingVehicle.getId()});
                this.runOnPlayerScheduler((org.bukkit.entity.Player)serverPlayer.getBukkitEntity(), () -> serverPlayer.connection.send((Packet)removeSittingVehiclePacket));
            }
        }
        if (this.npc instanceof LivingEntity) {
            Holder.Reference scaleAttribute = (Holder.Reference)BuiltInRegistries.ATTRIBUTE.get(ResourceLocation.parse((String)"minecraft:scale")).get();
            AttributeInstance attributeInstance = new AttributeInstance((Holder)scaleAttribute, a -> {});
            attributeInstance.setBaseValue((double)this.data.getScale());
            ClientboundUpdateAttributesPacket updateAttributesPacket = new ClientboundUpdateAttributesPacket(this.npc.getId(), List.of(attributeInstance));
            this.runOnPlayerScheduler((org.bukkit.entity.Player)serverPlayer.getBukkitEntity(), () -> serverPlayer.connection.send((Packet)updateAttributesPacket));
        }
    }

    @Override
    protected void refreshEntityData(org.bukkit.entity.Player player) {
        if (!this.isVisibleForPlayer.getOrDefault(player.getUniqueId(), false).booleanValue()) {
            return;
        }
        ServerPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        SynchedEntityData.DataItem[] itemsById = (SynchedEntityData.DataItem[])ReflectionUtils.getValue(this.npc.getEntityData(), "itemsById");
        ArrayList<SynchedEntityData.DataValue> entityData = new ArrayList<SynchedEntityData.DataValue>();
        for (SynchedEntityData.DataItem dataItem : itemsById) {
            entityData.add(dataItem.value());
        }
        ClientboundSetEntityDataPacket setEntityDataPacket = new ClientboundSetEntityDataPacket(this.npc.getId(), entityData);
        this.runOnPlayerScheduler((org.bukkit.entity.Player)serverPlayer.getBukkitEntity(), () -> serverPlayer.connection.send((Packet)setEntityDataPacket));
    }

    @Override
    public void move(org.bukkit.entity.Player player, boolean swingArm) {
        if (this.npc == null) {
            return;
        }
        ServerPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        this.npc.setPosRaw(this.data.getLocation().x(), this.data.getLocation().y(), this.data.getLocation().z());
        this.npc.setRot(this.data.getLocation().getYaw(), this.data.getLocation().getPitch());
        this.npc.setYHeadRot(this.data.getLocation().getYaw());
        this.npc.setXRot(this.data.getLocation().getPitch());
        this.npc.setYRot(this.data.getLocation().getYaw());
        ClientboundTeleportEntityPacket teleportEntityPacket = new ClientboundTeleportEntityPacket(this.npc.getId(), new PositionMoveRotation(new Vec3(this.data.getLocation().getX(), this.data.getLocation().getY(), this.data.getLocation().getZ()), Vec3.ZERO, this.data.getLocation().getYaw(), this.data.getLocation().getPitch()), Set.of(), false);
        this.runOnPlayerScheduler((org.bukkit.entity.Player)serverPlayer.getBukkitEntity(), () -> serverPlayer.connection.send((Packet)teleportEntityPacket));
        float angelMultiplier = 0.7111111f;
        ClientboundRotateHeadPacket rotateHeadPacket = new ClientboundRotateHeadPacket(this.npc, (byte)(this.data.getLocation().getYaw() * angelMultiplier));
        this.runOnPlayerScheduler((org.bukkit.entity.Player)serverPlayer.getBukkitEntity(), () -> serverPlayer.connection.send((Packet)rotateHeadPacket));
        if (swingArm && this.npc instanceof ServerPlayer) {
            ClientboundAnimatePacket animatePacket = new ClientboundAnimatePacket(this.npc, 0);
            this.runOnPlayerScheduler((org.bukkit.entity.Player)serverPlayer.getBukkitEntity(), () -> serverPlayer.connection.send((Packet)animatePacket));
        }
    }

    private ClientboundPlayerInfoUpdatePacket.Entry getEntry(ServerPlayer npcPlayer, ServerPlayer viewer) {
        GameProfile profile = npcPlayer.getGameProfile();
        if (this.data.isMirrorSkin()) {
            GameProfile newProfile = new GameProfile(profile.getId(), profile.getName());
            newProfile.getProperties().putAll((Multimap)viewer.getGameProfile().getProperties());
            profile = newProfile;
        }
        return new ClientboundPlayerInfoUpdatePacket.Entry(npcPlayer.getUUID(), profile, this.data.isShowInTab(), 0, npcPlayer.gameMode.getGameModeForPlayer(), npcPlayer.getTabListDisplayName(), true, -1, (RemoteChatSession.Data)Optionull.map((Object)npcPlayer.getChatSession(), RemoteChatSession::asData));
    }

    public void setSitting(ServerPlayer serverPlayer) {
        if (this.npc == null) {
            return;
        }
        if (this.sittingVehicle == null) {
            this.sittingVehicle = new Display.TextDisplay(net.minecraft.world.entity.EntityType.TEXT_DISPLAY, (Level)((CraftWorld)this.data.getLocation().getWorld()).getHandle());
        }
        this.sittingVehicle.setPos(this.data.getLocation().x(), this.data.getLocation().y(), this.data.getLocation().z());
        ServerEntity serverEntity = new ServerEntity(serverPlayer.serverLevel(), (Entity)this.sittingVehicle, 0, false, packet -> {}, (p, l) -> {}, Set.of());
        ClientboundAddEntityPacket addEntityPacket = new ClientboundAddEntityPacket((Entity)this.sittingVehicle, serverEntity);
        this.runOnPlayerScheduler((org.bukkit.entity.Player)serverPlayer.getBukkitEntity(), () -> serverPlayer.connection.send((Packet)addEntityPacket));
        this.sittingVehicle.passengers = ImmutableList.of(this.npc);
        ClientboundSetPassengersPacket packet2 = new ClientboundSetPassengersPacket((Entity)this.sittingVehicle);
        this.runOnPlayerScheduler((org.bukkit.entity.Player)serverPlayer.getBukkitEntity(), () -> serverPlayer.connection.send((Packet)packet2));
    }

    @Override
    public float getEyeHeight() {
        return this.npc.getEyeHeight();
    }

    @Override
    public int getEntityId() {
        return this.npc.getId();
    }

    public Entity getNpc() {
        return this.npc;
    }
}

