/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.skins.cache;

import de.oliver.fancynpcs.api.skins.SkinData;
import de.oliver.fancynpcs.skins.cache.SkinCache;
import de.oliver.fancynpcs.skins.cache.SkinCacheData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SkinCacheMemory
implements SkinCache {
    private final Map<String, SkinCacheData> cache = new ConcurrentHashMap<String, SkinCacheData>();

    @Override
    public SkinCacheData getSkin(String identifier) {
        if (!this.cache.containsKey(identifier)) {
            return null;
        }
        SkinCacheData skinCacheData = this.cache.get(identifier);
        if (skinCacheData.isExpired()) {
            this.cache.remove(identifier);
            return null;
        }
        return skinCacheData;
    }

    @Override
    public void addSkin(SkinData skin) {
        SkinCacheData skinCacheData = new SkinCacheData(skin, System.currentTimeMillis(), 604800000L);
        this.cache.put(skin.getParsedIdentifier(), skinCacheData);
    }

    @Override
    public void removeSkin(String identifier) {
        this.cache.remove(identifier);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }
}

