/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.commands.npc;

import de.oliver.cloud.annotations.Command;
import de.oliver.cloud.annotations.Permission;
import de.oliver.fancylib.translations.Translator;
import de.oliver.fancynpcs.FancyNpcs;
import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.events.NpcRemoveEvent;
import de.oliver.fancynpcs.api.events.NpcStopLookingEvent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public enum RemoveCMD {
    INSTANCE;

    private final Translator translator = FancyNpcs.getInstance().getTranslator();

    @Command(value="npc remove <npc>")
    @Permission(value={"fancynpcs.command.npc.remove"})
    public void onRemove(@NotNull CommandSender sender, @NotNull Npc npc) {
        if (new NpcRemoveEvent(npc, sender).callEvent()) {
            npc.removeForAll();
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (!npc.getIsLookingAtPlayer().getOrDefault(onlinePlayer.getUniqueId(), false).booleanValue()) continue;
                npc.getIsLookingAtPlayer().put(onlinePlayer.getUniqueId(), false);
                new NpcStopLookingEvent(npc, onlinePlayer).callEvent();
            }
            FancyNpcs.getInstance().getNpcManagerImpl().removeNpc(npc);
            this.translator.translate("npc_remove_success").replace("npc", npc.getData().getName()).send(sender);
        } else {
            this.translator.translate("command_npc_modification_cancelled").send(sender);
        }
    }
}

