/*
 * Decompiled with CFR 0.152.
 */
package org.mineskin.data;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.mineskin.MineSkinClient;
import org.mineskin.data.JobReference;
import org.mineskin.data.JobStatus;
import org.mineskin.exception.MineskinException;
import org.mineskin.response.SkinResponse;

public class JobInfo {
    private final String id;
    private final JobStatus status;
    private final long timestamp;
    private final String result;

    public JobInfo(String id, JobStatus status, long timestamp, String result) {
        this.id = id;
        this.status = status;
        this.timestamp = timestamp;
        this.result = result;
    }

    public String id() {
        return this.id;
    }

    public JobStatus status() {
        return this.status;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public Optional<String> result() {
        return Optional.ofNullable(this.result);
    }

    public CompletableFuture<JobReference> waitForCompletion(MineSkinClient client) {
        return client.queue().waitForCompletion(this);
    }

    public CompletableFuture<SkinResponse> getSkin(MineSkinClient client) {
        if (this.result == null) {
            throw new MineskinException("Job is not completed yet");
        }
        return client.skins().get(this.result);
    }

    public String toString() {
        return "JobInfo{id='" + this.id + "', status=" + String.valueOf((Object)this.status) + ", timestamp=" + this.timestamp + ", result='" + this.result + "'}";
    }
}

