/*
 * Decompiled with CFR 0.152.
 */
package org.mineskin;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.mineskin.MineSkinClient;
import org.mineskin.data.JobInfo;
import org.mineskin.data.JobReference;
import org.mineskin.data.JobStatus;
import org.mineskin.exception.MineskinException;

public class JobChecker {
    private final MineSkinClient client;
    private JobInfo jobInfo;
    private final ScheduledExecutorService executor;
    private CompletableFuture<JobReference> future;
    private final AtomicInteger attempts = new AtomicInteger(0);
    private final int maxAttempts;
    private final int initialDelay;
    private final int interval;

    public JobChecker(MineSkinClient client, JobInfo jobInfo, ScheduledExecutorService executor, int maxAttempts, int initialDelay, int interval) {
        this.client = client;
        this.jobInfo = jobInfo;
        this.executor = executor;
        this.maxAttempts = maxAttempts;
        this.initialDelay = initialDelay;
        this.interval = interval;
    }

    public CompletableFuture<JobReference> check() {
        this.future = new CompletableFuture();
        this.executor.schedule(this::checkJob, (long)this.initialDelay, TimeUnit.SECONDS);
        return this.future;
    }

    private void checkJob() {
        if (this.attempts.incrementAndGet() > this.maxAttempts) {
            this.future.completeExceptionally(new MineskinException("Max attempts reached"));
            return;
        }
        ((CompletableFuture)this.client.queue().get(this.jobInfo).thenAccept(response -> {
            JobInfo info = (JobInfo)response.getBody();
            if (info != null) {
                this.jobInfo = info;
            }
            if (this.jobInfo.status() == JobStatus.COMPLETED || this.jobInfo.status() == JobStatus.FAILED) {
                this.future.complete((JobReference)response);
            } else {
                this.executor.schedule(this::checkJob, (long)this.interval, TimeUnit.SECONDS);
            }
        })).exceptionally(throwable -> {
            this.future.completeExceptionally((Throwable)throwable);
            return null;
        });
    }
}

