/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.v1_20_4.attributes;

import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcAttribute;
import de.oliver.fancynpcs.v1_20_4.ReflectionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.EntityLiving;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;

public class LivingEntityAttributes {
    public static List<NpcAttribute> getAllAttributes() {
        ArrayList<NpcAttribute> attributes = new ArrayList<NpcAttribute>();
        attributes.add(new NpcAttribute("use_item", List.of("main_hand", "off_hand", "none"), Arrays.stream(EntityType.values()).filter(type -> type.getEntityClass() != null && LivingEntity.class.isAssignableFrom(type.getEntityClass())).toList(), LivingEntityAttributes::setUseItem));
        return attributes;
    }

    private static void setHurt(Npc npc, String value) {
        EntityLiving livingEntity = (EntityLiving)ReflectionHelper.getEntity(npc);
        boolean isHurt = Boolean.parseBoolean(value);
        if (isHurt) {
            livingEntity.aL = 1;
            livingEntity.aK = 1;
            livingEntity.T = true;
            livingEntity.m(0.0f);
        } else {
            livingEntity.aL = 0;
            livingEntity.aK = 0;
            livingEntity.T = false;
        }
    }

    private static void setUseItem(Npc npc, String value) {
        EntityLiving livingEntity = (EntityLiving)ReflectionHelper.getEntity(npc);
        switch (value.toUpperCase()) {
            case "NONE": {
                livingEntity.ft();
                break;
            }
            case "MAIN_HAND": {
                livingEntity.startUsingItem(EnumHand.a, true);
                break;
            }
            case "OFF_HAND": {
                livingEntity.startUsingItem(EnumHand.b, true);
            }
        }
    }
}

