/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.v1_20_2.attributes;

import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcAttribute;
import de.oliver.fancynpcs.v1_20_2.ReflectionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.item.EnumColor;
import org.bukkit.entity.Cat;
import org.bukkit.entity.EntityType;

public class CatAttributes {
    public static List<NpcAttribute> getAllAttributes() {
        ArrayList<NpcAttribute> attributes = new ArrayList<NpcAttribute>();
        attributes.add(new NpcAttribute("variant", Arrays.stream(Cat.Type.values()).map(Enum::name).toList(), List.of(EntityType.CAT), CatAttributes::setVariant));
        attributes.add(new NpcAttribute("pose", List.of("standing", "sleeping", "sitting"), List.of(EntityType.CAT), CatAttributes::setPose));
        attributes.add(new NpcAttribute("collar_color", List.of("RED", "BLUE", "YELLOW", "GREEN", "PURPLE", "ORANGE", "LIME", "MAGENTA", "BROWN", "WHITE", "GRAY", "LIGHT_GRAY", "LIGHT_BLUE", "BLACK", "CYAN", "PINK", "NONE"), List.of(EntityType.CAT), CatAttributes::setCollarColor));
        return attributes;
    }

    private static void setVariant(Npc npc, String value) {
        EntityCat cat = (EntityCat)ReflectionHelper.getEntity(npc);
        BuiltInRegistries.aj.b(MinecraftKey.a((String)value.toLowerCase(), (char)':')).ifPresent(arg_0 -> ((EntityCat)cat).a(arg_0));
    }

    private static void setPose(Npc npc, String value) {
        EntityCat cat = (EntityCat)ReflectionHelper.getEntity(npc);
        switch (value.toLowerCase()) {
            case "standing": {
                cat.setInSittingPose(false, false);
                cat.A(false);
                break;
            }
            case "sleeping": {
                cat.setInSittingPose(false, false);
                cat.A(true);
                break;
            }
            case "sitting": {
                cat.A(false);
                cat.z(true);
                cat.setInSittingPose(true, false);
            }
        }
    }

    private static void setCollarColor(Npc npc, String value) {
        EntityCat cat = (EntityCat)ReflectionHelper.getEntity(npc);
        if (value.equalsIgnoreCase("none") || value.isEmpty()) {
            cat.x(false);
            return;
        }
        try {
            EnumColor color = EnumColor.valueOf((String)value.toUpperCase());
            if (!cat.s()) {
                cat.x(true);
            }
            cat.a(color);
        }
        catch (IllegalArgumentException e) {
            System.out.print("Invalid Color: " + value);
        }
    }
}

