/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.v1_20_1.attributes;

import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcAttribute;
import de.oliver.fancynpcs.v1_20_1.ReflectionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.entity.animal.EntityParrot;
import org.bukkit.entity.EntityType;

public class ParrotAttributes {
    public static List<NpcAttribute> getAllAttributes() {
        ArrayList<NpcAttribute> attributes = new ArrayList<NpcAttribute>();
        attributes.add(new NpcAttribute("variant", Arrays.stream(EntityParrot.Variant.values()).map(Enum::name).toList(), List.of(EntityType.PARROT), ParrotAttributes::setVariant));
        attributes.add(new NpcAttribute("pose", List.of("standing", "sitting"), List.of(EntityType.PARROT), ParrotAttributes::setPose));
        return attributes;
    }

    private static void setVariant(Npc npc, String value) {
        EntityParrot parrot = (EntityParrot)ReflectionHelper.getEntity(npc);
        EntityParrot.Variant variant = EntityParrot.Variant.valueOf((String)value.toUpperCase());
        parrot.a(variant);
    }

    private static void setPose(Npc npc, String value) {
        EntityParrot parrot = (EntityParrot)ReflectionHelper.getEntity(npc);
        switch (value.toLowerCase()) {
            case "standing": {
                parrot.z(false);
                parrot.setInSittingPose(false, false);
                break;
            }
            case "sitting": {
                parrot.z(true);
                parrot.setInSittingPose(true, false);
            }
        }
    }
}

