/*
 * Decompiled with CFR 0.152.
 */
package de.oliver.fancynpcs.v1_19_4.attributes;

import de.oliver.fancylib.ReflectionUtils;
import de.oliver.fancynpcs.api.Npc;
import de.oliver.fancynpcs.api.NpcAttribute;
import de.oliver.fancynpcs.v1_19_4.MappingKeys1_19_4;
import de.oliver.fancynpcs.v1_19_4.ReflectionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.world.entity.animal.EntityPanda;
import org.bukkit.entity.EntityType;

public class PandaAttributes {
    public static List<NpcAttribute> getAllAttributes() {
        ArrayList<NpcAttribute> attributes = new ArrayList<NpcAttribute>();
        attributes.add(new NpcAttribute("gene", Arrays.stream(EntityPanda.Gene.values()).map(Enum::name).toList(), List.of(EntityType.PANDA), PandaAttributes::setGene));
        attributes.add(new NpcAttribute("eating", List.of("true", "false"), List.of(EntityType.PANDA), PandaAttributes::setEating));
        attributes.add(new NpcAttribute("pose", List.of("standing", "sitting", "onBack", "rolling"), List.of(EntityType.PANDA), PandaAttributes::setPose));
        return attributes;
    }

    private static void setGene(Npc npc, String value) {
        EntityPanda panda = (EntityPanda)ReflectionHelper.getEntity(npc);
        EntityPanda.Gene gene = EntityPanda.Gene.valueOf((String)value.toUpperCase());
        panda.a(gene);
    }

    private static void setPose(Npc npc, String value) {
        EntityPanda panda = (EntityPanda)ReflectionHelper.getEntity(npc);
        switch (value.toLowerCase()) {
            case "standing": {
                PandaAttributes.setFlag(panda, 8, false);
                panda.A(false);
                panda.x(false);
                break;
            }
            case "sitting": {
                panda.A(false);
                panda.x(false);
                PandaAttributes.setFlag(panda, 8, true);
                break;
            }
            case "onback": {
                PandaAttributes.setFlag(panda, 8, false);
                panda.A(false);
                panda.x(true);
                break;
            }
            case "rolling": {
                PandaAttributes.setFlag(panda, 8, false);
                panda.x(false);
                panda.A(true);
            }
        }
    }

    private static void setEating(Npc npc, String value) {
        EntityPanda panda = (EntityPanda)ReflectionHelper.getEntity(npc);
        boolean eating = Boolean.parseBoolean(value);
        panda.y(eating);
    }

    private static void setFlag(EntityPanda panda, int mask, boolean value) {
        DataWatcherObject DATA_ID_FLAGS = (DataWatcherObject)ReflectionUtils.getValue(panda, MappingKeys1_19_4.PANDA__DATA_ID_FLAGS.getMapping());
        byte b0 = (Byte)panda.aj().a(DATA_ID_FLAGS);
        if (value) {
            panda.aj().b(DATA_ID_FLAGS, (Object)((byte)(b0 | mask)));
        } else {
            panda.aj().b(DATA_ID_FLAGS, (Object)((byte)(b0 & ~mask)));
        }
    }
}

